
<?php $__env->startSection('title'); ?>
    <?php echo e(__('All Notifications')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('All Notifications')); ?></h2>
                            <a href="<?php echo e(route('admin.read-notification', 0)); ?>" class="title-btn"><i
                                    icon-name="check"></i> Mark all read</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="notification-list">
                                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['single-list', 'read' => $notification->read]) ?>">
                                        <div class="cont">
                                            <div class="icon"><i icon-name="<?php echo e($notification->icon); ?>"></i></div>
                                            <div class="contents">
                                                <?php echo e($notification->notice); ?>

                                                <div class="time"><?php echo e($notification->created_at->diffForHumans()); ?></div>
                                            </div>
                                        </div>
                                        <div class="link">
                                            <a href="<?php echo e(route('admin.read-notification', $notification->id)); ?>"
                                               class="site-btn-xs red-btn"><i
                                                    icon-name="external-link"></i><?php echo e(__('Explore')); ?></a>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <?php echo e($notifications->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/notification/index.blade.php ENDPATH**/ ?>