<?php
    $landingContent =\App\Models\LandingContent::where('type','counter')->where('locale',app()->getLocale())->get();
?>

<section class="rock-fun-fact-area o-x-clip">
    <div class="container p-relative">
        <div class="row align-items-center">
            <div class="col-xxl-12">
                <div class="fun-fact-counter-grid">
                    <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-counter-item">
                        <div class="icon">
                            <img src="<?php echo e(asset($content->icon)); ?>" alt="counter icon">
                        </div>
                        <div class="content">
                            <p class="description"><?php echo e($content->title); ?></p>
                            <h6 class="title">
                                <?php
                                    $description = $content->description;
                                    if ($description >= 1000000000) {
                                        $formattedDescription = round($description / 1000000000, 1) . 'B+';
                                    } elseif ($description >= 1000000) {
                                        $formattedDescription = round($description / 1000000, 1) . 'M+';
                                    } elseif ($description >= 1000) {
                                        $formattedDescription = round($description / 1000, 1) . 'K+';
                                    } else {
                                        $formattedDescription = number_format($description);
                                    }
                                ?>
                                <span class=""><?php echo e($formattedDescription); ?></span>
                            </h6>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="fun-fact-bg" data-background="<?php echo e(asset('frontend/theme_base/hardrock/images/bg/fun-fact-glow.png')); ?>"></div>
                </div>
            </div>
        </div>
        <div class="rock-fun-fact-shapes">
            <div class="shape-one">
                <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/fun-fact/01.png')); ?>" alt="">
            </div>
            <div class="shape-two">
                <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/fun-fact/02.png')); ?>" alt="">
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/investify/home/include/__counter.blade.php ENDPATH**/ ?>