
<?php $__env->startSection('title'); ?>
<?php echo e(__('Schema Preview')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Schema Preview section start -->
<div class="rock-schema-preview-area">
    <div class="rock-dashboard-card">
        <div class="rock-dashboard-title-inner">
            <div class="content">
                <h3 class="rock-dashboard-tile"><?php echo e(__('Review and Confirm Investment')); ?></h3>
            </div>
        </div>
        <div class="rock-schema-preview-forrm">
            <form action="<?php echo e(route('user.invest-now')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="schema-preview-table table-responsive">
                    <div class="rock-custom-table">
                        <div class="contents">
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Select Schema:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <div class="rock-single-input">
                                        <div class="input-select">
                                            <select id="select-schema" name="schema_id" required>
                                                <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($plan->id); ?>" <?php if($plan->id == $schema->id ): ?> selected <?php endif; ?>><?php echo e($plan->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Profit Holiday:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <span id="holiday">
                                        <?php if( null != $schema->off_days): ?>
                                        <?php echo e(implode(', ', json_decode($schema->off_days,true))); ?>

                                        <?php else: ?>
                                        <?php echo e(__('No')); ?>

                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>


                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Amount:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <span id="amount">
                                        <?php echo e($schema->type == 'range' ? 'Minimum ' . $schema->min_amount .' '.$currency. ' - ' . 'Maximum ' . $schema->max_amount.' '.$currency :  $schema->fixed_amount.' '.$currency); ?>

                                    </span>
                                </div>
                            </div>
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Enter Amount:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <div class="rock-single-input">
                                        <div class="input-field input-group">
                                            <input type="text"
                                                   placeholder="<?php echo e(__('Enter Amount')); ?>"
                                                   <?php if($schema->type == 'fixed'): ?>
                                                   value="<?php echo e($schema->fixed_amount); ?>"
                                                   readonly
                                                   <?php endif; ?>
                                                   data-min="<?php echo e($schema->type == 'range' ? $schema->min_amount : 0); ?>"
                                                   data-max="<?php echo e($schema->type == 'range' ? $schema->max_amount : ''); ?>"
                                                   oninput="this.value = validateDouble(this.value)"
                                                   name="invest_amount"
                                                   id="enter-amount"
                                                   required>
                                            <span class="input-group-text"><?php echo e($currency); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Select Wallet:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <div class="rock-single-input">
                                        <div class="input-select">
                                            <select name="wallet" required id="selectWallet">
                                                <option value="main">
                                                    <?php echo e(__('Main Wallet ( ') . $user->balance.' '. $currency); ?> )
                                                </option>
                                                <option value="profit">
                                                    <?php echo e(__('Profit Wallet ( ') . $user->profit_balance.' '. $currency); ?> )
                                                </option>
                                                <option value="gateway"><?php echo e(__('Direct Gateway')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="site-table-list gatewaySelect"></div>
                            <div class="site-table-list manual-row"></div>
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Return of Interest:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <?php if($schema->interest_type == 'fixed'): ?>
                                    <span id="return-interest">
                                        <?php echo e($schema->schedule->name . ' ' . $schema->fixed_roi .' '. ($schema->roi_interest_type == 'percentage' ? '%' : '$')); ?>

                                    </span>
                                    <?php else: ?>
                                        <span id="return-interest">
                                        <?php echo e($schema->schedule->name . ' ' . $schema->min_roi . '-' . $schema->max_roi .' '. ($schema->roi_interest_type == 'percentage' ? '%' : '$')); ?>

                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Number of Period:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <span id="number-period">
                                        <?php echo e(( $schema->return_type == 'period' ? $schema->number_of_period : 'Unlimited').($schema->number_of_period == 1 ? ' Time' : ' Times' )); ?>

                                    </span>
                                </div>
                            </div>
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Capital Back:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <span id="capital_back"><?php echo e($schema->capital_back ? 'Yes' : 'No'); ?></span>
                                </div>
                            </div>
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <span><?php echo e(__('Total Investment Amount:')); ?></span>
                                </div>
                                <div class="site-table-col">
                                    <span id="total-investment-amount">
                                        <?php echo e($schema->fixed_amount ?? ''); ?> <?php echo e($currency); ?>

                                    </span>
                                </div>
                            </div>
                            <div class="rock-input-btn-wrap mt-30">
                                <button type="submit" class="site-btn gradient-btn radius-10" href="add-money-successfully.html">
                                    <?php echo e(__('Invest Now')); ?>

                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.4" d="M19 13C19 17.4183 15.4183 21 11 21C6.58172 21 3 17.4183 3 13C3 8.58172 6.58172 5 11 5C15.4183 5 19 8.58172 19 13Z" fill="white" />
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M16 3.75C15.5858 3.75 15.25 3.41421 15.25 3C15.25 2.58579 15.5858 2.25 16 2.25H21C21.4142 2.25 21.75 2.58579 21.75 3V8C21.75 8.41421 21.4142 8.75 21 8.75C20.5858 8.75 20.25 8.41421 20.25 8V4.81066L10.5303 14.5303C10.2374 14.8232 9.76256 14.8232 9.46967 14.5303C9.17678 14.2374 9.17678 13.7626 9.46967 13.4697L19.1893 3.75H16Z" fill="white" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Schema Preview section end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
        "use strict";

        var typingTimer;                // Timer identifier
        var doneTypingInterval = 800;   // Time in ms (500ms)

        // When the schema is selected
        $("#select-schema").on('change', function(e) {
            e.preventDefault();
            var id = $(this).val();
            var invest_amount = $("#enter-amount");
            invest_amount.val('');
            invest_amount.attr('readonly', false);

            var url = '<?php echo e(route("user.schema.select", ":id")); ?>';
            url = url.replace(':id', id);

            $.ajax({
                url: url,
                success: function(result) {
                    $('#amount').html(result.amount_range);
                    $('#holiday').html(result.holiday);
                    $('#return-interest').html(result.return_interest);
                    $('#number-period').html(result.number_period);
                    $('#capital_back').html(result.capital_back);

                    // Set min and max data attributes for validation
                    if (result.min_amount && result.max_amount) {
                        invest_amount.attr('data-min', result.min_amount);
                        invest_amount.attr('data-max', result.max_amount);
                    } else {
                        invest_amount.removeAttr('data-min');
                        invest_amount.removeAttr('data-max');
                    }

                    if (result.invest_amount > 0) {
                        invest_amount.val(result.invest_amount);
                        invest_amount.attr('readonly', true);
                    }

                    // Update the Total Investment Amount
                    $("#total-investment-amount").html(invest_amount.val() + " <?php echo e($currency); ?>");
                }
            });
        });

        // When the user starts typing in the Enter Amount field
        $("#enter-amount").on('keyup', function(e) {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(doneTyping, doneTypingInterval);
        });

        // When the user is still typing
        $("#enter-amount").on('keydown', function(e) {
            clearTimeout(typingTimer);
        });

        // Function to execute when typing is finished
        function doneTyping() {
            var invest_amount = $("#enter-amount");
            var amount = parseFloat(invest_amount.val());
            var min = parseFloat(invest_amount.attr('data-min'));
            var max = parseFloat(invest_amount.attr('data-max'));

            // Validate the full input only after user has finished typing
            if (amount < min || amount > max) {
                invest_amount.val(''); // Clear the input if the value is out of range
                alert('Please enter an amount between ' + min + ' and ' + max + ' <?php echo e($currency); ?>');
            } else {
                // Update the Total Investment Amount in real-time
                $("#total-investment-amount").html(amount + " <?php echo e($currency); ?>");
            }
        }

        // Handling the wallet change event
        $("#selectWallet").on('change', function(e) {
            $('.gatewaySelect').empty();
            $('.manual-row').empty();
            var wallet = $(this).val();
            if (wallet === 'gateway') {
                $.get('<?php echo e(route("gateway.list")); ?>', function(data) {
                    $('.gatewaySelect').append(data)
                    $('select').niceSelect();
                });
            }
        });

        // Handling the gateway change event
        $('body').on('change', '#gatewaySelect', function(e) {
            e.preventDefault();
            $('.manual-row').empty();
            var code = $(this).val();
            var url = '<?php echo e(route("user.deposit.gateway",":code")); ?>';
            url = url.replace(':code', code);
            $.get(url, function(data) {
                $('.invest-gateway-charge').text('Charge ' + data.charge_gateway);
                if (data.credentials !== undefined) {
                    $('.manual-row').append(data.credentials);
                    imagePreview();
                }
            });
        });
    });


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/coin_orbit/schema/preview.blade.php ENDPATH**/ ?>