
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Why Choose Us Section')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Why Choose Us Section')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="site-tab-bars">
            <ul class="nav nav-pills" id="pills-tab" role="tablist">
                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item" role="presentation">
                        <a
                            href=""
                            class="nav-link  <?php echo e($loop->index == 0 ?'active' : ''); ?>"
                            id="pills-informations-tab"
                            data-bs-toggle="pill"
                            data-bs-target="#<?php echo e($language->locale); ?>"
                            type="button"
                            role="tab"
                            aria-controls="pills-informations"
                            aria-selected="true"
                        ><i icon-name="languages"></i><?php echo e($language->name); ?></a
                        >
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </ul>
        </div>

        <div class="tab-content" id="pills-tabContent">

            <?php $__currentLoopData = $groupData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php
                    $data = new Illuminate\Support\Fluent($value);
                ?>

                <div
                    class="tab-pane fade <?php echo e($loop->index == 0 ?'show active' : ''); ?>"
                    id="<?php echo e($key); ?>"
                    role="tabpanel"
                    aria-labelledby="pills-informations-tab"
                >

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="site-card">
                                <div class="site-card-header">
                                    <h3 class="title"><?php echo e(__('Titles and Activity')); ?></h3>
                                </div>
                                <div class="site-card-body">
                                    <form action="<?php echo e(route('admin.page.section.section.update')); ?>" method="post"
                                          enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="section_code" value="whychooseus">
                                        <input type="hidden" name="section_locale" value="<?php echo e($key); ?>">
                                        <?php if($key == 'en'): ?>
                                            <div class="site-input-groups row">
                                                <label for=""
                                                       class="col-sm-3 col-label pt-0"><?php echo e(__('Section Activity')); ?><i
                                                        icon-name="info" data-bs-toggle="tooltip" title=""
                                                        data-bs-original-title="Manage Section Visibility"></i></label>
                                                <div class="col-sm-3">
                                                    <div class="site-input-groups">
                                                        <div class="switch-field">
                                                            <input type="radio" id="active" name="status"
                                                                   <?php if($status): ?> checked
                                                                   <?php endif; ?> value="1"/>
                                                            <label for="active"><?php echo e(__('Show')); ?></label>
                                                            <input type="radio" id="deactivate" name="status"
                                                                   <?php if(!$status): ?> checked
                                                                   <?php endif; ?> value="0"/>
                                                            <label for="deactivate"><?php echo e(__('Hide')); ?></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>


                                        <div class="site-input-groups row">
                                            <label for=""
                                                   class="col-sm-3 col-label"><?php echo e(__('Why Choose Us Title Small')); ?></label>
                                            <div class="col-sm-9">
                                                <input type="text" name="title_small" class="box-input"
                                                       value="<?php echo e($data->title_small); ?>">
                                            </div>
                                        </div>
                                        <div class="site-input-groups row">
                                            <label for=""
                                                   class="col-sm-3 col-label"><?php echo e(__('Why Choose Us Title Big')); ?></label>
                                            <div class="col-sm-9">
                                                <input type="text" name="title_big" class="box-input"
                                                       value="<?php echo e($data->title_big); ?>">
                                            </div>
                                        </div>
                                        <?php if($key == 'en'): ?>
                                            <div class="site-input-groups row">
                                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label">
                                                    <?php echo e(__('Why Choose Us Left Image')); ?>

                                                </div>
                                                <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                                                    <div class="wrap-custom-file">
                                                        <input type="file" name="left_img" id="whychooseusLeftImg"
                                                               accept=".gif, .jpg, .png"/>
                                                        <label for="whychooseusLeftImg" id="left_img"
                                                               <?php if($data->left_img): ?>  class="file-ok"
                                                               style="background-image: url(<?php echo e(asset($data->left_img)); ?>)" <?php endif; ?>>
                                                            <img class="upload-icon"
                                                                 src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                                 alt=""/>
                                                            <span><?php echo e(__('Update Image')); ?></span>
                                                        </label>
                                                        <?php $isHidden = $data->left_img; $img_field = 'left_img'; ?>
                <div data-des="<?php echo $img_field; ?>" <?php if(!$isHidden) echo 'hidden'; ?> class="close remove-img <?php echo $img_field; ?>"><i icon-name="x"></i></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="site-input-groups row">
                                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label">
                                                    <?php echo e(__('Why Choose Us Right Image')); ?>

                                                </div>
                                                <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                                                    <div class="wrap-custom-file">
                                                        <input type="file" name="right_img" id="whychooseusRightImg"
                                                               accept=".gif, .jpg, .png"/>
                                                        <label for="whychooseusRightImg" id="right_img"
                                                               <?php if($data->right_img): ?>  class="file-ok"
                                                               style="background-image: url(<?php echo e(asset($data->right_img)); ?>)" <?php endif; ?>>
                                                            <img class="upload-icon"
                                                                 src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                                 alt=""/>
                                                            <span><?php echo e(__('Update Image')); ?></span>
                                                        </label>
                                                        <?php $isHidden = $data->right_img; $img_field = 'right_img'; ?>
                <div data-des="<?php echo $img_field; ?>" <?php if(!$isHidden) echo 'hidden'; ?> class="close remove-img <?php echo $img_field; ?>"><i icon-name="x"></i></div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="row">
                                            <div class="offset-sm-3 col-sm-9">
                                                <button type="submit"
                                                        class="site-btn-sm primary-btn w-100"><?php echo e(__('Save Changes')); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Why Choose Us Contents')); ?></h3>
                    <div class="card-header-links">
                        <a href="" class="card-header-link" type="button" data-bs-toggle="modal"
                           data-bs-target="#addNew"><?php echo e(__('Add New')); ?></a>
                    </div>
                </div>
                <div class="site-card-body">
                    <div class="site-table table-responsive">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Icon Class')); ?></th>
                                <th scope="col"><?php echo e(__('Title')); ?></th>
                                <th scope="col"><?php echo e(__('Description')); ?></th>
                                <th scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if(content_exists($content->icon)): ?>
                                        <img class="avatar" src="<?php echo e(asset($content->icon)); ?>" alt="">
                                        <?php else: ?>
                                        <?php echo e($content->icon); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($content->title); ?>

                                    </td>
                                    <td><?php echo e($content->description); ?></td>
                                    <td>
                                        <button class="round-icon-btn primary-btn editContent" type="button"
                                                data-id="<?php echo e($content->id); ?>">
                                            <i icon-name="edit-3"></i>
                                        </button>
                                        <button class="round-icon-btn red-btn deleteContent" type="button"
                                                data-id="<?php echo e($content->id); ?>">
                                            <i icon-name="trash-2"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>


                </div>
            </div>

        </div>
    </div>

    <!-- Modal for Add New  -->
    <?php echo $__env->make('backend.page.section.include.__add_new_whychooseus', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Add New How It Works End -->

    <!-- Modal for Edit -->
    <?php echo $__env->make('backend.page.section.include.__edit_whychooseus', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Edit  End-->

    <!-- Modal for Delete  -->
    <?php echo $__env->make('backend.page.section.include.__delete_whychooseus', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Delete  End-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backend.page.section.include.__section_image_remove', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $('.editContent').on('click', function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');

            var url = '<?php echo e(route("admin.page.content-edit", ":id")); ?>';
            url = url.replace(':id', id);

            $.ajax({
                url: url,
                type: 'GET',
                success: function (response) {

                    // Handle the response HTML
                    $('#target-element').html(response.html);
                    $('#editContent').modal('show');
                    initIconType();
                },
                error: function (xhr) {
                    // Handle any errors that occurred during the request
                    console.log(xhr.responseText);
                }
            });
        });

        $('.deleteContent').on('click', function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');
            $('#deleteId').val(id);
            $('#deleteContent').modal('show');
        });


        $('#iconType').on('change',function(){
            const iconType = $(this).val();

            if(iconType == 'class'){
                $('#classField').removeClass('d-none');
                $('#imageField').addClass('d-none');
            }else{
                $('#imageField').removeClass('d-none')
                $('#classField').addClass('d-none');
            }
        });



        function initIconType()
        {
            const editIconType = $('#editIconTypes').val();

            if(editIconType == 'class'){
                $('#editClassField').removeClass('d-none');
                $('#editImageField').addClass('d-none');
            }else{
                $('#editImageField').removeClass('d-none')
                $('#editClassField').addClass('d-none');
            }
        }

    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/page/section/whychooseus.blade.php ENDPATH**/ ?>