
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Transactions')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title"><?php echo e($title); ?></h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="<?php echo e(request()->url()); ?>" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="<?php echo e(request('query')); ?>" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                                <div class="filter d-flex">
                                    <select class="form-select form-select-sm me-2" name="filter_by_transaction_type">
                                        <option value="" selected><?php echo e(__('Filter By Transaction Type')); ?></option>
                                        <option value="investment" <?php echo e(request('filter_by_transaction_type') == 'investment' ? 'selected' : ''); ?>><?php echo e(__('Investment')); ?></option>
                                        <option value="referral" <?php echo e(request('filter_by_transaction_type') == 'referral' ? 'selected' : ''); ?>><?php echo e(__('Referral')); ?></option>
                                        <option value="interest" <?php echo e(request('filter_by_transaction_type') == 'interest' ? 'selected' : ''); ?>><?php echo e(__('Interest')); ?></option>
                                        <option value="bonus" <?php echo e(request('filter_by_transaction_type') == 'bonus' ? 'selected' : ''); ?>><?php echo e(__('Bonus')); ?></option>
                                        <option value="signup_bonus" <?php echo e(request('filter_by_transaction_type') == 'signup_bonus' ? 'selected' : ''); ?>><?php echo e(__('Signup Bonus')); ?></option>
                                    </select>

                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Date')); ?></th>
                                <th scope="col"><?php echo e(__('User')); ?></th>
                                <th scope="col"><?php echo e(__('Amount')); ?></th>
                                <th scope="col"><?php echo e(__('Type')); ?></th>
                                <th scope="col"><?php echo e(__('Profit From')); ?></th>
                                <th scope="col"><?php echo e(__('Description')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->created_at); ?></td>
                                    <td><?php echo $__env->make('backend.transaction.include.__user', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo $__env->make('backend.transaction.include.__txn_amount', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo $__env->make('backend.transaction.include.__txn_type', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo e($item->from_user_id != null ? \App\Models\User::find($item->from_user_id)?->username : 'System'); ?></td>
                                    <td><?php echo e($item->description); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                            <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($data->links('backend.include.__pagination')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/transaction/profit.blade.php ENDPATH**/ ?>