<?php
$investors = \App\Models\Invest::with('schema','user')->latest()->take(6)->get();
$withdraws = \App\Models\Transaction::where('type',\App\Enums\TxnType::Withdraw)->take(6)->latest()->get();
?>

<!-- Investors section start -->
<section class="investors-section p-relative z-index-11 section-space">
    <div class="container">
        <div class="row">
            <div class="col-xxl-5 col-xl-6 col-lg-6">
                <div class="section-heading section-title-space">
                    <span class="section-subtitle"><?php echo e($data['title_small']); ?></span>
                    <h2 class="section-title"><?php echo e($data['title_big']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row gy-30">
            <div class="col-xxl-6 col-xl-6">
                <div class="investors-table-wrapper">
                    <div class="table-card" data-background="<?php echo e(asset('frontend/theme_base/coinefy/images/investors/withdraws-table.png')); ?>">
                        <h5 class="table-card-title"><?php echo e(__('Recent Investors')); ?></h5>

                        <div class="investors-table table-responsive">
                            <table class="table">
                                <tbody>
                                    <?php $__currentLoopData = $investors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    $calculateInterest = ($investor->interest * $investor->invest_amount) / 100;
                                    $interest = $investor->interest_type != 'percentage' ? $investor->interest : $calculateInterest;
                                    ?>
                                    <tr>
                                        <td>
                                            <h6 class="fs-12 white-text"><?php echo e($investor->user->full_name); ?></h6>
                                        </td>
                                        <td class="fs-10 white-text"><?php echo e($investor->created_at); ?></td>
                                        <td><span class="active-status"><?php echo e($investor->user->status ? __('Active') : __('DeActive')); ?></span></td>
                                        <td>
                                            <span class="w-img"><img src="<?php echo e(asset('frontend/theme_base/coinefy/images/icons/stock-icon.png')); ?>" alt="stock-icon"></span>
                                        </td>
                                        <td><span class="fs-10 retro-lime-text">+<?php echo e($investor->already_return_profit * $interest); ?> <?php echo e($currency); ?></span></td>
                                        <td>
                                            <span class="fs-14 fw-6 white-text"><?php echo e($investor->invest_amount); ?> <?php echo e($currency); ?></span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="coin-one">
                        <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/investors/coin-01.png')); ?>" alt="coin">
                    </div>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6">
                <div class="investors-table-wrapper style-two">
                    <div class="table-card" data-background="<?php echo e(asset('frontend/theme_base/coinefy/images/investors/investors-table.png')); ?>">
                        <h5 class="table-card-title"><?php echo e(__('Recent Withdraws')); ?></h5>
                        <div class="investors-table table-responsive">
                            <table class="table">
                                <tbody>
                                    <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <h6 class="fs-12 white-text"><?php echo e($withdraw->description); ?></h6>
                                        </td>
                                        <td class="fs-10 white-text"><?php echo e($withdraw->created_at); ?></td>
                                        <td><span class="active-status warning"><?php echo e(ucfirst($withdraw->status->value)); ?></span></td>
                                        <td><span class="fs-10 retro-lime-text">
                                        <?php if($withdraw->status == \App\Enums\TxnStatus::Success): ?>
                                        -<?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?>

                                        <?php elseif($withdraw->status == \App\Enums\TxnStatus::Failed): ?>
                                        +<?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?>

                                        <?php elseif($withdraw->status == \App\Enums\TxnStatus::Pending): ?>
                                        <?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?>

                                        <?php endif; ?>
                                        </span></td>
                                        <td>
                                            <span class="fs-14 fw-6 white-text"><?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?></span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="coin-two">
                        <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/investors/coin-02.png')); ?>" alt="coin">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Investors section end -->
</div><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/coinefy/home/include/__recent.blade.php ENDPATH**/ ?>