<?php
$landingContent =\App\Models\LandingContent::where('type','faq')->where('locale',app()->getLocale())->get()->chunk(3);

?>

<div class="big-coin-wrapper o-x-clip p-relative z-index-11">
    <div class="big-coin-shapes">
        <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/shapes/big-crypto-coins.png')); ?>" alt="crypto-coins">
    </div>
    <section class="faq-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-6 col-lg-6">
                    <div class="section-heading text-center section-title-space">
                        <span class="section-subtitle"><?php echo e($data['title_small']); ?></span>
                        <h2 class="section-title"><?php echo e($data['title_big']); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row gy-30 justify-content-center">
                <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $contents): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xxl-6">
                    <div class="accordion-wrapper site-faq">
                        <div class="accordion" id="accordion<?php echo e($key); ?>">
                            <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $cont): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h6 class="accordion-header" id="heading<?php echo e($key); ?>-<?php echo e($k); ?>">
                                    <button class="accordion-button <?php echo e($k != 0 ? 'collapsed' : ''); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($key); ?>-<?php echo e($k); ?>" aria-expanded="<?php echo e($k == 0 ? 'true' : 'false'); ?>" aria-controls="collapse<?php echo e($key); ?>-<?php echo e($k); ?>">
                                        <span>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.4" d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81V16.18C2 19.83 4.17 22 7.81 22H16.18C19.82 22 21.99 19.83 21.99 16.19V7.81C22 4.17 19.83 2 16.19 2Z" fill="white" />
                                                <path d="M16 12.75H8C7.59 12.75 7.25 12.41 7.25 12C7.25 11.59 7.59 11.25 8 11.25H16C16.41 11.25 16.75 11.59 16.75 12C16.75 12.41 16.41 12.75 16 12.75Z" fill="white" />
                                            </svg>
                                        </span><?php echo e($cont->title); ?>

                                    </button>
                                </h6>
                                <div id="collapse<?php echo e($key); ?>-<?php echo e($k); ?>" class="accordion-collapse collapse <?php echo e($k == 0 ? 'show' : ''); ?>" aria-labelledby="heading<?php echo e($key); ?>-<?php echo e($k); ?>" data-bs-parent="#accordion<?php echo e($key); ?>">
                                    <div class="accordion-body">
                                        <p><?php echo nl2br(e($cont->description)); ?></p>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
</div><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/coinefy/home/include/__faq.blade.php ENDPATH**/ ?>