<?php
    $investors = \App\Models\Invest::with('schema')->latest()->take(6)->get();
    $withdraws = \App\Models\Transaction::where('type',\App\Enums\TxnType::Withdraw)->take(6)->latest()->get();
?>

<section class="section-style-2 light-yellow-bg coin-right">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12">
                <div class="section-title text-center">
                    <h4 data-aos="fade-down" data-aos-duration="2000"><?php echo e($data['title_small']); ?></h4>
                    <h2 data-aos="fade-down" data-aos-duration="1500">
                        <?php echo e($data['title_big']); ?>

                    </h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-6 col-lg-12">
                <div class="site-card" data-aos="fade-right" data-aos-duration="2000">
                    <div class="site-card-header">
                        <h3 class="title"><?php echo e(__('Recent Investors')); ?></h3>
                    </div>
                    <div class="site-card-body">
                        <div class="site-transactions">
                            <?php $__currentLoopData = $investors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php
                                    $calculateInterest = ($investor->interest*$investor->invest_amount)/100;
                                    $interest = $investor->interest_type != 'percentage' ? $investor->interest : $calculateInterest;
                                ?>

                                <div class="single">
                                    <div class="left">
                                        <div class="icon">
                                            <i icon-name="user-plus"></i>
                                        </div>
                                        <div class="content">
                                            <div class="title"><?php echo e($investor->user->full_name); ?></div>
                                            <div class="date"><?php echo e($investor->created_at); ?></div>
                                        </div>
                                    </div>
                                    <div class="middle">
                                        <?php if($investor->user->status): ?>
                                            <div class="status site-badge badge-success"><?php echo e(__('Active')); ?></div>
                                        <?php else: ?>
                                            <div class="status site-badge badge-pending"><?php echo e(__('DeActive')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="right">
                                        <div class="amount">
                                            <div class="net in">
                                                +<?php echo e($investor->already_return_profit*$interest); ?> <?php echo e($currency); ?></div>
                                            <div class="total"><?php echo e($investor->invest_amount); ?> <?php echo e($currency); ?></div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-12">
                <div class="site-card" data-aos="fade-left" data-aos-duration="2000">
                    <div class="site-card-header">
                        <h3 class="title"><?php echo e(__('Recent Withdraws')); ?></h3>
                    </div>
                    <div class="site-card-body">
                        <div class="site-transactions">
                            <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single">
                                    <div class="left">
                                        <div class="icon">
                                            <i icon-name="arrow-up-left"></i>
                                        </div>
                                        <div class="content">
                                            <div class="title"><?php echo e($withdraw->description); ?></div>
                                            <div class="date"><?php echo e($withdraw->created_at); ?></div>
                                        </div>
                                    </div>
                                    <div class="middle">


                                        <?php if($withdraw->status == \App\Enums\TxnStatus::Success): ?>
                                            <div class="status site-badge badge-success"><?php echo e(__('Success')); ?></div>
                                        <?php elseif( $withdraw->status == \App\Enums\TxnStatus::Failed): ?>
                                            <div class="status site-badge badge-failed"><?php echo e(__('Cancelled')); ?></div>
                                        <?php else: ?>
                                            <div class="status site-badge badge-pending"><?php echo e(__('Pending')); ?></div>
                                        <?php endif; ?>

                                    </div>
                                    <div class="right">
                                        <div class="amount">
                                            <?php if($withdraw->status == \App\Enums\TxnStatus::Success): ?>
                                                <div class="net in">+<?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?></div>
                                            <?php elseif($withdraw->status == \App\Enums\TxnStatus::Failed): ?>
                                                <div class="net out">
                                                    -<?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?></div>
                                            <?php endif; ?>

                                            <div class="total"><?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?></div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/mining_invest/home/include/__recent.blade.php ENDPATH**/ ?>