

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <section class="rock-auth-section fix">
        <div class="container">
           <div class="rock-auth-wrapper">
              <div class="rock-auth-main">
                 <div class="rock-auth-logo">
                    <a href="<?php echo e(route('home')); ?>">
                       <img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="logo">
                    </a>
                 </div>
                 <div class="rock-auth-main-inner">
                    <div class="rock-auth-from">
                       <div class="rock-auth-content">
                          <h3 class="title"><?php echo e($data['title']); ?></h3>
                          <p class="description"><?php echo e($data['bottom_text']); ?></p>
                       </div>
                       <?php if($errors->any()): ?>
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <strong><?php echo e($error); ?></strong>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                       <form action="<?php echo e(route('login')); ?>" method="POST" id="loginForm">
                            <?php echo csrf_field(); ?>
                          <div class="row justify-content-center">
                             <div class="col-xxl-6">
                                <div class="rock-single-input">
                                   <label class="rock-input-label" for="email"><?php echo e(__('Email Or Username')); ?><span>*</span></label>
                                   <div class="input-field">
                                      <input type="email" name="email">
                                   </div>
                                </div>
                                <div class="rock-single-input">
                                   <label class="rock-input-label" for="password"><?php echo e(__('Password')); ?><span>*</span></label>
                                   <div class="input-field">
                                      <input type="password" name="password">
                                   </div>
                                </div>
                                <?php if($googleReCaptcha): ?>
                                    <div class="g-recaptcha mb-3" id="feedback-recaptcha"
                                         data-sitekey="<?php echo e(json_decode($googleReCaptcha->data,true)['google_recaptcha_key']); ?>">
                                    </div>
                                <?php endif; ?>
                                <div class="rock-auth-remember-inner">
                                   <div class="rock-auth-checkbox">
                                      <input id="terms_condition" type="checkbox">
                                      <label class="terms-condition" for="terms_condition"><?php echo e(__('Remember me')); ?></label>
                                   </div>
                                   <?php if(Route::has('password.request')): ?>
                                   <div class="rock-auth-forgot">
                                      <p><a href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forget Password')); ?></a></p>
                                   </div>
                                   <?php endif; ?>
                                </div>
                             </div>
                          </div>
                       </form>
                       <div class="rock-auth-bottm">
                          <div class="rock-auth-btn">
                             <button type="submit" form="loginForm" class="site-btn gradient-btn"><?php echo e(__('Account Login')); ?></button>
                          </div>
                          <p class="description">
                            <?php echo e(__("Don't have an account?")); ?>

                            <a href="<?php echo e(route('register')); ?>"><?php echo e(__('Signup for free')); ?></a>
                        </p>
                       </div>
                    </div>
                 </div>
              </div>
              <div class="rock-auth-shapes">
                 <div class="shape-one">
                    <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/rock-shapes/auth/auth-01.png')); ?>" alt="auth shape">
                 </div>
                 <div class="shape-two">
                    <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/rock-shapes/auth/auth-02.png')); ?>" alt="auth shape">
                 </div>
              </div>
           </div>
        </div>
     </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php if($googleReCaptcha): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/investify/auth/login.blade.php ENDPATH**/ ?>