
<?php $__env->startSection('title'); ?>
    <?php echo e(__('All Customers')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title"><?php echo e($title); ?></h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="<?php echo e(request()->url()); ?>" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="<?php echo e(request('query')); ?>" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                                <div class="filter d-flex">
                                    <select class="form-select form-select-sm me-2" name="email_status" aria-label=".form-select-sm example">
                                        <option value="" selected><?php echo e(__('Filter By Email Status')); ?></option>
                                        <option value="verified" <?php echo e(request('email_status') == 'verified' ? 'selected' : ''); ?>><?php echo e(__('Email Verified')); ?></option>
                                        <option value="unverified" <?php echo e(request('email_status') == 'unverified' ? 'selected' : ''); ?>><?php echo e(__('Email Unverified')); ?></option>
                                    </select>
                                    <select class="form-select form-select-sm me-2" name="kyc_status" aria-label=".form-select-sm example">
                                        <option value="" selected><?php echo e(__('Filter By KYC')); ?></option>
                                        <option value="1" <?php echo e(request('kyc_status') == '1' ? 'selected' : ''); ?>><?php echo e(__('Verified')); ?></option>
                                        <option value="0" <?php echo e(request('kyc_status') == '0' ? 'selected' : ''); ?>><?php echo e(__('Unverified')); ?></option>
                                    </select>
                                    <select class="form-select form-select-sm" name="status" aria-label=".form-select-sm example">
                                        <option value="" selected><?php echo e(__('Filter By Status')); ?></option>
                                        <option value="1" <?php echo e(request('status') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                        <option value="0" <?php echo e(request('status') == '0' ? 'selected' : ''); ?>><?php echo e(__('Disabled')); ?></option>
                                        <option value="2" <?php echo e(request('status') == '2' ? 'selected' : ''); ?>><?php echo e(__('Closed')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Avatar')); ?></th>
                                <th scope="col"><?php echo e(__('User Name')); ?></th>
                                <th scope="col"><?php echo e(__('Email')); ?></th>
                                <th scope="col"><?php echo e(__('Balance')); ?></th>
                                <th scope="col"><?php echo e(__('Profit')); ?></th>
                                <th scope="col"><?php echo e(__('Email Status')); ?></th>
                                <th scope="col"><?php echo e(__('KYC')); ?></th>
                                <th scope="col"><?php echo e(__('Status')); ?></th>
                                <th scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <?php echo $__env->make('backend.user.include.__avatar', ['avatar' => $user->avatar, 'first_name' => $user->first_name,'last_name' => $user->last_name], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                    
                                    <td><a class="link" href="<?php echo e(route('admin.user.edit',$user->id)); ?>"><?php echo e(safe($user->username)); ?></a></td>

                                    <td><?php echo e(Str::limit($user->email,20)); ?></td>
                                    <td><?php echo e($currencySymbol.$user->balance); ?></td>
                                    <td><strong><?php echo e($user->total_profit . ' ' . setting('site_currency')); ?></strong></td>
                                    <td>
                                        <?php if($user->email_verified_at != null): ?>
                                            <div class="site-badge success"><?php echo e(__('Verified')); ?></div>
                                        <?php else: ?>
                                            <div class="site-badge pending"><?php echo e(__('Unverified')); ?></div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo $__env->make('backend.user.include.__kyc' , ['kyc' => $user->kyc], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                    <td>
                                        <?php echo $__env->make('backend.user.include.__status', ['status' => $user->status], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>

                                    <td>
                                        <?php echo $__env->make('backend.user.include.__action', ['user' => $user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                            <?php endif; ?>
                            </tbody>
                            <!-- Modal for Send Email -->
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-mail-send')): ?>
                            <?php echo $__env->make('backend.user.include.__mail_send', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                        <!-- Modal for Send Email-->
                        </table>
                        <?php echo e($users->links('backend.include.__pagination')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

            //send mail modal form open
            $('body').on('click', '.send-mail', function() {
                var id = $(this).data('id');
                var name = $(this).data('name');
                $('#name').html(name);
                $('#userId').val(id);
                $('#sendEmail').modal('toggle')
            })

            // Delete
            $('body').on('click', '#deleteModal', function() {
                var id = $(this).data('id');
                var name = $(this).data('name');

                $('#data-name').html(name);
                var url = '<?php echo e(route("admin.user.destroy", ":id")); ?>';
                url = url.replace(':id', id);
                $('#deleteForm').attr('action', url);
                $('#delete').modal('toggle')

            });

        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/user/index.blade.php ENDPATH**/ ?>