

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Register')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="rock-auth-section fix">
        <div class="container">
            <div class="rock-auth-wrapper">
                <div class="rock-auth-main">
                    <div class="rock-auth-logo">
                        <a href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset(setting('site_logo', 'global'))); ?>" alt="logo">
                        </a>
                    </div>
                    <div class="rock-auth-main-inner">
                        <div class="rock-auth-from">
                            <div class="rock-auth-content">
                                <h3 class="title"><?php echo e($data['title']); ?></h3>
                                <p class="description"><?php echo e($data['bottom_text']); ?></p>
                            </div>
                            <?php if($errors->any()): ?>
                                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <strong><?php echo e($error); ?></strong>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            <?php endif; ?>
                            <form action="<?php echo e(route('register')); ?>" id="signUpForm" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row gy-24">
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                        <div class="rock-single-input">
                                            <label class="rock-input-label"
                                                for="first_name"><?php echo e(__('First Name')); ?><span>*</span></label>
                                            <div class="input-field">
                                                <input type="text" name="first_name" value="<?php echo e(old('first_name')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                        <div class="rock-single-input">
                                            <label class="rock-input-label"
                                                for="last_name"><?php echo e(__('Last Name')); ?><span>*</span></label>
                                            <div class="input-field">
                                                <input type="text" name="last_name" value="<?php echo e(old('last_name')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12">
                                        <div class="rock-single-input">
                                            <label class="rock-input-label"
                                                for="email"><?php echo e(__('Email Address')); ?><span>*</span></label>
                                            <div class="input-field">
                                                <input type="email" name="email" value="<?php echo e(old('email')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(getPageSetting('username_show')): ?>
                                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                            <div class="rock-single-input">
                                                <label class="rock-input-label"
                                                    for="username"><?php echo e(__('Username')); ?><span>*</span></label>
                                                <div class="input-field">
                                                    <input type="text" name="username" value="<?php echo e(old('username')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(getPageSetting('country_show')): ?>
                                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                            <div class="rock-single-input">
                                                <label class="rock-input-label"
                                                    for="c-select"><?php echo e(__('Select Country')); ?><span>*</span></label>
                                                <div class="input-select">
                                                    <select name="country" id="countrySelect">
                                                        <?php $__currentLoopData = getCountries(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php if($location->country_code == $country['code']): ?> selected <?php endif; ?>
                                                                value="<?php echo e($country['name'] . ':' . $country['dial_code']); ?>">
                                                                <?php echo e($country['name']); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(getPageSetting('phone_show')): ?>
                                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                            <div class="rock-single-input">
                                                <label class="rock-input-label"
                                                    for="phonen"><?php echo e(__('Phone Number')); ?><span>*</span></label>
                                                <div class="input-field input-group">
                                                    <span class="input-group-text"
                                                        id="dial-code"><?php echo e(getLocation()->dial_code); ?></span>
                                                    <input type="text" name="phone" value="<?php echo e(old('phone')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(getPageSetting('referral_code_show')): ?>
                                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                            <div class="rock-single-input">
                                                <label class="rock-input-label" for="invite"><?php echo e(__('Referral Code')); ?>

                                                    <?php if(settingValue('sign_up_referral')): ?>
                                                        <span>*</span>
                                                    <?php endif; ?>
                                                </label>
                                                <div class="input-field">
                                                    <input type="text" name="invite"
                                                        <?php if(settingValue('sign_up_referral')): ?> required <?php endif; ?>
                                                        value="<?php echo e(request('invite') ?? old('invite')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(getPageSetting('register_custom_fields')): ?>
                                        <?php
                                            $customFields = json_decode(getPageSetting('register_custom_fields'), true);
                                        ?>
                                        <?php $__currentLoopData = $customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                                <div class="rock-single-input">
                                                    <label class="rock-input-label" for=""><?php echo e($field['name']); ?>

                                                        <?php if($field['validation'] == 'required'): ?>
                                                            <span class="text-danger">*</span>
                                                        <?php endif; ?>
                                                    </label>
                                                    <?php if($field['type'] == 'textarea'): ?>
                                                        <div class="input-field">
                                                            <textarea name="custom_fields_data[<?php echo e($field['name']); ?>]" class="form-control" rows="3"
                                                                <?php if($field['validation'] == 'required'): ?> required <?php endif; ?>></textarea>
                                                        </div>
                                                    <?php elseif(in_array($field['type'], ['file', 'camera'])): ?>
                                                        <div class="upload-custom-file without-image">
                                                            <input type="file" id="<?php echo e($key); ?>"
                                                                name="custom_fields_data[<?php echo e($field['name']); ?>]"
                                                                accept=".gif, .jpg, .png" onchange="showCloseButton(event)"
                                                                <?php if($field['type'] == 'camera'): ?> capture="user" <?php endif; ?> />
                                                            <label for="<?php echo e($key); ?>">
                                                                <span class="upload-icon">
                                                                    <svg width="48" height="48" viewBox="0 0 48 48"
                                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <g filter="url(#filter0_i_2427_12057)">
                                                                            <path
                                                                                d="M14 18L34 18C38.4183 18 42 21.5817 42 26V34C42 38.4183 38.4183 42 34 42H14C9.58172 42 6 38.4183 6 34L6 26C6 21.5817 9.58172 18 14 18Z"
                                                                                fill="url(#paint0_linear_2427_12057)" />
                                                                        </g>
                                                                        <path
                                                                            d="M14 18.5L34 18.5C38.1421 18.5 41.5 21.8579 41.5 26V34C41.5 38.1421 38.1421 41.5 34 41.5H14C9.85787 41.5 6.5 38.1421 6.5 34L6.5 26C6.5 21.8579 9.85786 18.5 14 18.5Z"
                                                                            stroke="white" stroke-opacity="0.08" />
                                                                        <g filter="url(#filter1_i_2427_12057)">
                                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                                d="M16.9393 13.0607C16.3536 12.4749 16.3536 11.5251 16.9393 10.9393L22.9393 4.93934C23.5251 4.35355 24.4749 4.35355 25.0607 4.93934L31.0607 10.9393C31.6464 11.5251 31.6464 12.4749 31.0607 13.0607C30.4749 13.6464 29.5251 13.6464 28.9393 13.0607C27.6701 11.7915 25.5 12.6904 25.5 14.4853L25.5 30C25.5 30.8284 24.8284 31.5 24 31.5C23.1716 31.5 22.5 30.8284 22.5 30L22.5 14.4853C22.5 12.6904 20.3299 11.7915 19.0607 13.0607C18.4749 13.6464 17.5251 13.6464 16.9393 13.0607Z"
                                                                                fill="url(#paint1_linear_2427_12057)" />
                                                                        </g>
                                                                        <path
                                                                            d="M17.2929 12.7071C16.9024 12.3166 16.9024 11.6834 17.2929 11.2929L23.2929 5.29289C23.6834 4.90237 24.3166 4.90237 24.7071 5.29289L30.7071 11.2929C31.0976 11.6834 31.0976 12.3166 30.7071 12.7071C30.3166 13.0976 29.6834 13.0976 29.2929 12.7071C27.7087 11.1229 25 12.2449 25 14.4853L25 30C25 30.5523 24.5523 31 24 31C23.4477 31 23 30.5523 23 30L23 14.4853C23 12.2449 20.2913 11.1229 18.7071 12.7071C18.3166 13.0976 17.6834 13.0976 17.2929 12.7071Z"
                                                                            stroke="white" stroke-opacity="0.08" />
                                                                        <defs>
                                                                            <filter id="filter0_i_2427_12057" x="2" y="18"
                                                                                width="40" height="28"
                                                                                filterUnits="userSpaceOnUse"
                                                                                color-interpolation-filters="sRGB">
                                                                                <feFlood flood-opacity="0"
                                                                                    result="BackgroundImageFix" />
                                                                                <feBlend mode="normal" in="SourceGraphic"
                                                                                    in2="BackgroundImageFix"
                                                                                    result="shape" />
                                                                                <feColorMatrix in="SourceAlpha"
                                                                                    type="matrix"
                                                                                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                                    result="hardAlpha" />
                                                                                <feOffset dx="-4" dy="4" />
                                                                                <feGaussianBlur stdDeviation="5" />
                                                                                <feComposite in2="hardAlpha"
                                                                                    operator="arithmetic" k2="-1"
                                                                                    k3="1" />
                                                                                <feColorMatrix type="matrix"
                                                                                    values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                                                                <feBlend mode="normal" in2="shape"
                                                                                    result="effect1_innerShadow_2427_12057" />
                                                                            </filter>
                                                                            <filter id="filter1_i_2427_12057" x="12.5"
                                                                                y="4.5" width="19" height="31"
                                                                                filterUnits="userSpaceOnUse"
                                                                                color-interpolation-filters="sRGB">
                                                                                <feFlood flood-opacity="0"
                                                                                    result="BackgroundImageFix" />
                                                                                <feBlend mode="normal" in="SourceGraphic"
                                                                                    in2="BackgroundImageFix"
                                                                                    result="shape" />
                                                                                <feColorMatrix in="SourceAlpha"
                                                                                    type="matrix"
                                                                                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                                    result="hardAlpha" />
                                                                                <feOffset dx="-4" dy="4" />
                                                                                <feGaussianBlur stdDeviation="5" />
                                                                                <feComposite in2="hardAlpha"
                                                                                    operator="arithmetic" k2="-1"
                                                                                    k3="1" />
                                                                                <feColorMatrix type="matrix"
                                                                                    values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                                                                <feBlend mode="normal" in2="shape"
                                                                                    result="effect1_innerShadow_2427_12057" />
                                                                            </filter>
                                                                            <linearGradient id="paint0_linear_2427_12057"
                                                                                x1="6" y1="18"
                                                                                x2="28.1538" y2="51.2308"
                                                                                gradientUnits="userSpaceOnUse">
                                                                                <stop stop-color="#FDD819" />
                                                                                <stop offset="1"
                                                                                    stop-color="#F81717" />
                                                                            </linearGradient>
                                                                            <linearGradient id="paint1_linear_2427_12057"
                                                                                x1="16.5" y1="31.5"
                                                                                x2="39.4245" y2="18.7641"
                                                                                gradientUnits="userSpaceOnUse">
                                                                                <stop stop-color="#FDD819" />
                                                                                <stop offset="1"
                                                                                    stop-color="#F81717" />
                                                                            </linearGradient>
                                                                        </defs>
                                                                    </svg>
                                                                </span>
                                                                <span><?php echo e(__('Select')); ?> <?php echo e($field['name']); ?></span>
                                                            </label>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="input-field">
                                                            <input type="text"
                                                                name="custom_fields_data[<?php echo e($field['name']); ?>]"
                                                                class="box-input"
                                                                <?php if($field['validation'] == 'required'): ?> required <?php endif; ?>>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>

                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                        <div class="rock-single-input">
                                            <label class="rock-input-label"
                                                for="password"><?php echo e(__('Password')); ?><span>*</span></label>
                                            <div class="input-field">
                                                <input type="password" name="password">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                                        <div class="rock-single-input">
                                            <label class="rock-input-label"
                                                for="cpassword"><?php echo e(__('Confirm Password')); ?><span>*</span></label>
                                            <div class="input-field">
                                                <input type="password" name="password_confirmation">
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($googleReCaptcha): ?>
                                        <div class="g-recaptcha" id="feedback-recaptcha"
                                            data-sitekey="<?php echo e(json_decode($googleReCaptcha->data, true)['google_recaptcha_key']); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <div class="rock-auth-checkbox">
                                        <input id="terms_condition" type="checkbox" name="i_agree" value="yes">
                                        <label class="terms-condition" for="terms_condition">
                                            <?php echo e(__('I agree with')); ?>

                                            <a href="<?php echo e(url('/privacy-policy')); ?>"><?php echo e(__('Privacy & Policy')); ?></a>
                                            <?php echo e(__('and')); ?>

                                            <a
                                                href="<?php echo e(url('/terms-and-conditions')); ?>"><?php echo e(__('Terms & Condition')); ?></a>
                                        </label>
                                    </div>
                                </div>
                            </form>
                            <div class="rock-auth-bottm">
                                <div class="rock-auth-btn">
                                    <button class="site-btn gradient-btn xs-w-100" form="signUpForm"
                                        type="submit"><?php echo e(__('Create Account')); ?></button>
                                </div>
                                <p><?php echo e(__('Already have an account?')); ?>

                                    <a href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="rock-auth-shapes">
                    <div class="shape-one">
                        <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/rock-shapes/auth/auth-01.png')); ?>"
                            alt="auth shape">
                    </div>
                    <div class="shape-two">
                        <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/rock-shapes/auth/auth-02.png')); ?>"
                            alt="auth shape">
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php if($googleReCaptcha): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
    <script>
        $('#countrySelect').on('change', function(e) {
            "use strict";
            e.preventDefault();
            var country = $(this).val();
            $('#dial-code').html(country.split(":")[1])
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/investify/auth/register.blade.php ENDPATH**/ ?>