

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Authentication section start -->
    <section class="td-authentication-section">
        <div class="container">
            <div class="auth-main-grid">
                <div class="auth-from-main">
                    <div class="auth-intro-content mb-40">
                        <h2 class="title"><?php echo e(__('Log In')); ?></h2>
                    </div>
                    <div class="auth-from-box">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <strong><?php echo e($error); ?></strong>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <form id="login-form" <?php echo e(route('login')); ?> method="POST" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="row gy-24">
                                <div class="col-xxl-12">
                                    <div class="td-form-group input-fill has-right-icon">
                                        <label class="input-label"><?php echo e(__('Email Address')); ?><span>*</span> </label>
                                        <div class="input-field">
                                            <input type="email" name="email" class="form-control" required>
                                            <span class="input-icon"><i class="icon-profile-circle"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-12">
                                    <div class="td-form-group input-fill has-right-icon">
                                        <label class="input-label"><?php echo e(__('Password')); ?> <span>*</span></label>
                                        <div class="input-field">
                                            <input type="password" name="password" class="form-control password-input"
                                                required>
                                            <span class="input-icon eyeicon"><i class="icon-eye-slash"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="auth-login-option">
                                <div class="animate-custom">
                                    <input class="inp-cbx" id="auth_remind" type="checkbox" style="display: none;">
                                    <label class="cbx" for="auth_remind">
                                        <span>
                                            <svg width="12px" height="9px" viewbox="0 0 12 9">
                                                <polyline points="1 5 4 8 11 1"></polyline>
                                            </svg>
                                        </span>
                                        <span><?php echo e(__('Keep me logged in')); ?></span>
                                    </label>
                                </div>
                                <?php if(Route::has('password.request')): ?>
                                    <div class="forget-content">
                                        <span><a class="td-underline-btn"
                                                href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forget Password')); ?></a></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if($googleReCaptcha): ?>
                                <div class="g-recaptcha mb-3" id="feedback-recaptcha"
                                    data-sitekey="<?php echo e(json_decode($googleReCaptcha->data, true)['google_recaptcha_key']); ?>">
                                </div>
                            <?php endif; ?>
                            <div class="auth-from-btn-wrap">
                                <button class="td-btn gradient-btn radius-8 w-100" type="submit"> <span
                                        class="btn-icon"><svg width="25" height="24" viewBox="0 0 25 24"
                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M9.607 5.448C10.205 3.698 12.623 3.645 13.332 5.289L13.392 5.449L14.199 7.809C14.5732 8.90406 15.4033 9.7834 16.475 10.22L16.692 10.301L19.052 11.107C20.802 11.705 20.855 14.123 19.212 14.832L19.052 14.892L16.692 15.699C15.5966 16.0729 14.7168 16.9031 14.28 17.975L14.199 18.191L13.393 20.552C12.795 22.302 10.377 22.355 9.669 20.712L9.607 20.552L8.801 18.192C8.42706 17.0966 7.59692 16.2168 6.525 15.78L6.309 15.699L3.949 14.893C2.198 14.295 2.145 11.877 3.789 11.169L3.949 11.107L6.309 10.301C7.40406 9.92681 8.2834 9.09671 8.72 8.025L8.801 7.809M11.5 6.094L10.694 8.454C10.124 10.1245 8.84742 11.4592 7.204 12.103L6.954 12.194L4.594 13L6.954 13.806C8.62445 14.376 9.9592 15.6526 10.603 17.296L10.694 17.546L11.5 19.906L12.306 17.546C12.876 15.8755 14.1526 14.5408 15.796 13.897L16.046 13.807L18.406 13L16.046 12.194C14.3755 11.624 13.0408 10.3474 12.397 8.704L12.307 8.454M19.5 2C19.8817 2 20.2301 2.21726 20.398 2.56L20.446 2.677L20.796 3.703L21.823 4.053C22.2064 4.18326 22.4734 4.5319 22.4993 4.93602C22.5251 5.34014 22.3047 5.71995 21.941 5.898L21.823 5.946L20.797 6.296L20.447 7.323C20.3165 7.70631 19.9677 7.9731 19.5636 7.99872C19.1595 8.02435 18.7799 7.80376 18.602 7.44L18.554 7.323L18.204 6.297L17.177 5.947C16.7936 5.81674 16.5266 5.4681 16.5007 5.06398C16.4749 4.65986 16.6953 4.28005 17.059 4.102L17.177 4.054L18.203 3.704L18.553 2.677C18.6912 2.27192 19.072 1.99974 19.5 2Z"
                                                fill="white" />
                                        </svg>
                                    </span> <?php echo e(__('Sign In')); ?>

                                </button>
                            </div>
                        </form>
                        <div class="auth-privacy-policy">
                            <p class="description"><?php echo e(__('By clicking Sign in, you agree to our')); ?> <a
                                    class="td-underline-btn" href="<?php echo e(url('/terms-and-conditions')); ?>"> Terms of
                                    Service</a> <span>and</span> <a class="td-underline-btn"
                                    href="<?php echo e(url('/privacy-policy')); ?>"> Privacy Policy</a></p>
                        </div>
                    </div>
                </div>
                <div class="auth-banner-wrapper has-right"
                    data-background="<?php echo e(asset('frontend/theme_base/coin_orbit/images/bg/auth-bg.png')); ?>">
                    <div class="auth-banner-content-box">
                        <div class="auth-logo">
                            <a href="<?php echo e(route('home')); ?>">
                                <img src="<?php echo e(asset(setting('site_logo', 'global'))); ?>" alt="logo">
                            </a>
                        </div>
                        <div class="auth-banner-contents">
                            <h1 class="title"><?php echo e($data['title']); ?></h1>
                            <p class="description"><?php echo e($data['bottom_text']); ?></p>
                            <a href="<?php echo e(route('register')); ?>" class="td-btn gradient-btn radius-8" type="submit">
                                <span class="btn-icon"><svg width="25" height="24" viewBox="0 0 25 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M9.607 5.448C10.205 3.698 12.623 3.645 13.332 5.289L13.392 5.449L14.199 7.809C14.5732 8.90406 15.4033 9.7834 16.475 10.22L16.692 10.301L19.052 11.107C20.802 11.705 20.855 14.123 19.212 14.832L19.052 14.892L16.692 15.699C15.5966 16.0729 14.7168 16.9031 14.28 17.975L14.199 18.191L13.393 20.552C12.795 22.302 10.377 22.355 9.669 20.712L9.607 20.552L8.801 18.192C8.42706 17.0966 7.59692 16.2168 6.525 15.78L6.309 15.699L3.949 14.893C2.198 14.295 2.145 11.877 3.789 11.169L3.949 11.107L6.309 10.301C7.40406 9.92681 8.2834 9.09671 8.72 8.025L8.801 7.809M11.5 6.094L10.694 8.454C10.124 10.1245 8.84742 11.4592 7.204 12.103L6.954 12.194L4.594 13L6.954 13.806C8.62445 14.376 9.9592 15.6526 10.603 17.296L10.694 17.546L11.5 19.906L12.306 17.546C12.876 15.8755 14.1526 14.5408 15.796 13.897L16.046 13.807L18.406 13L16.046 12.194C14.3755 11.624 13.0408 10.3474 12.397 8.704L12.307 8.454M19.5 2C19.8817 2 20.2301 2.21726 20.398 2.56L20.446 2.677L20.796 3.703L21.823 4.053C22.2064 4.18326 22.4734 4.5319 22.4993 4.93602C22.5251 5.34014 22.3047 5.71995 21.941 5.898L21.823 5.946L20.797 6.296L20.447 7.323C20.3165 7.70631 19.9677 7.9731 19.5636 7.99872C19.1595 8.02435 18.7799 7.80376 18.602 7.44L18.554 7.323L18.204 6.297L17.177 5.947C16.7936 5.81674 16.5266 5.4681 16.5007 5.06398C16.4749 4.65986 16.6953 4.28005 17.059 4.102L17.177 4.054L18.203 3.704L18.553 2.677C18.6912 2.27192 19.072 1.99974 19.5 2Z"
                                            fill="white" />
                                    </svg>
                                </span>
                                <span class="btn-text"><?php echo e(__('Sign Up')); ?></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Authentication section end -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php if($googleReCaptcha): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('.eyeicon').on('click', function() {
            let passwordInput = $(this).siblings('.password-input');
            let icon = $(this).find('i');

            if (passwordInput.attr('type') === 'password') {
                passwordInput.attr('type', 'text');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            } else {
                passwordInput.attr('type', 'password');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            }
        });
    });
</script>

<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/coin_orbit/auth/login.blade.php ENDPATH**/ ?>