
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Pending Manual Deposit')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('deposit_content'); ?>
    <div class="col-xl-12 col-md-12">
        <div class="site-card">
            <div class="site-card-body table-responsive">
                <div class="site-table table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Transaction ID')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Charge')); ?></th>
                            <th><?php echo e(__('Gateway')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $pendings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pending): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <tr>
                                <td><?php echo e($pending->created_at); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__user', ['item' => $pending], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($pending->tnx); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_amount', ['item' => $pending], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($pending->charge . ' ' . setting('site_currency', 'global')); ?></td>
                                <td><?php echo e($pending->method); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_status', ['status' => $pending->status], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo $__env->make('backend.deposit.include.__action', ['id' => $pending->id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                        <?php endif; ?>
                        </tbody>
                    </table>

                    <?php echo e($pendings->links('backend.include.__pagination')); ?>

                </div>
            </div>
        </div>
        <!-- Modal for Pending Deposit Approval -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('deposit-action')): ?>
            <div
                    class="modal fade"
                    id="deposit-action-modal"
                    tabindex="-1"
                    aria-labelledby="editPendingDepositModalLabel"
                    aria-hidden="true"
            >
                <div class="modal-dialog modal-md modal-dialog-centered">
                    <div class="modal-content site-table-modal">
                        <div class="modal-body popup-body">
                            <button
                                    type="button"
                                    class="btn-close"
                                    data-bs-dismiss="modal"
                                    aria-label="Close"
                            ></button>
                            <div class="popup-body-text deposit-action">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
    <?php endif; ?>

    <!-- Modal for Pending Deposit Approval -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function ($) {
            "use strict";

            let loader = '<div class="text-center"><img src="<?php echo e(asset('front/images/loader.gif')); ?>" width="100"><h5><?php echo e(__('Please wait')); ?>...</h5></div>';

            //send mail modal form open
            $('body').on('click', '#deposit-action', function () {
                $('.deposit-action').html(loader);

                var id = $(this).data('id');
                var url = '<?php echo e(route("admin.deposit.action",":id")); ?>';
                url = url.replace(':id', id);
                $.get(url, function (data) {
                    $('.deposit-action').html(data)
                    imagePreview()
                });

                $('#deposit-action-modal').modal('toggle');
            })


        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.deposit.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/deposit/manual.blade.php ENDPATH**/ ?>