<?php
$investors = \App\Models\Invest::with('schema','user')->latest()->take(6)->get();
$withdraws = \App\Models\Transaction::where('type',\App\Enums\TxnType::Withdraw)->take(6)->latest()->get();
?>

<!-- Investors section start -->
<section class="td-investors-section section_space-bottom p-relative o-x-clip">
    <div class="container">
        <div class="row gy-30">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="section-title-wrapper section_title_space">
                    <span class="section-subtitle"><?php echo e($data['title_small']); ?></span>
                    <h2 class="section-title has_fade_anim"><?php echo e($data['title_big']); ?></h2>
                </div>
                <div class="table-container table-responsive has_fade_anim" data-fade-from="left">
                    <div class="table-heading">
                        <h4 class="title"><?php echo e(__('Recent Withdraws')); ?></h4>
                    </div>
                    <table class="td-table">
                        <tbody>
                        <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <div class="description">
                                    <div class="icon">
                                          <span>
                                             <img src="<?php echo e(asset('frontend/theme_base/coin_orbit/images/investors/icons/withdraw.png')); ?>" alt="Withdraw Icons">
                                          </span>
                                    </div>
                                    <div class="contents">
                                        <h6 class="subject-title"><?php echo e($withdraw->description); ?></h6>
                                        <div class="d-flex align-items-center gap-2">
                                            <span class="date"><?php echo e($withdraw->created_at); ?></span>
                                            <span class="td-badge badge-warning">
                                                <?php echo e(ucfirst($withdraw->status->value)); ?>

                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="warning-text fs-12 fw-5">
                                    <?php if($withdraw->status == \App\Enums\TxnStatus::Success): ?>
                                        -<?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?>

                                    <?php elseif($withdraw->status == \App\Enums\TxnStatus::Failed): ?>
                                        +<?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?>

                                    <?php elseif($withdraw->status == \App\Enums\TxnStatus::Pending): ?>
                                        <?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?>

                                    <?php endif; ?>
                                </span>
                                <p style="color: #b7d3ff;" class="fs-14 fw-6"><?php echo e(__('Total')); ?>: <?php echo e($withdraw->final_amount); ?> <?php echo e($currency); ?></p>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="table-container table-responsive has_fade_anim" data-fade-from="right">
                    <div class="table-heading">
                        <h4 class="title">Recent Investors</h4>
                    </div>
                    <table class="td-table">
                        <tbody>
                        <?php $__currentLoopData = $investors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $calculateInterest = ($investor->interest * $investor->invest_amount) / 100;
                                $interest = $investor->interest_type != 'percentage' ? $investor->interest : $calculateInterest;
                            ?>
                        <tr>
                            <td>
                                <div class="description">
                                    <div class="icon">
                                          <span>
                                             <img src="<?php echo e(asset('frontend/theme_base/coin_orbit/images/investors/icons/user.png')); ?>" alt="User Icons">
                                          </span>
                                    </div>
                                    <div class="contents">
                                        <h6 class="subject-title"><?php echo e($investor->user->full_name); ?></h6>
                                        <div class="d-flex align-items-center gap-2">
                                            <span class="date"><?php echo e($investor->created_at); ?></span>
                                            <span class="td-badge badge-success"><?php echo e($investor->user->status ? __('Active') : __('DeActive')); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="success-text fs-12 fw-5">+<?php echo e($investor->already_return_profit * $interest); ?> <?php echo e($currency); ?></span>
                                <p style="color: #b7d3ff;" class="fs-14 fw-6"><?php echo e($investor->invest_amount); ?> <?php echo e($currency); ?></p>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <!-- Add more rows as necessary -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="investors-shapes">
        <div class="glow">
            <img src="<?php echo e(asset('frontend/theme_base/coin_orbit/images/investors/glow.png')); ?>" alt="Investors Glow">
        </div>
        <div class="line">
            <img src="<?php echo e(asset('frontend/theme_base/coin_orbit/images/investors/line.png')); ?>" alt="Investors Line">
        </div>
    </div>
</section>
<!-- Investors section end --><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/coin_orbit/home/include/__recent.blade.php ENDPATH**/ ?>