<!-- Page Sidebar Start-->
<div class="rock-sidebar-wrapper">
    <div class="sidebar-inner">
        <div class="user-sidebar">
            <div class="site-logo">
                <a href="<?php echo e(route('home')); ?>" class="logo"><img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="logo not found">
                </a>
                <div class="back-btn"><i class="fa fa-angle-left"></i></div>
            </div>
            <div class="rock-sidebar-sidebar-nav">
                <nav class="user-nav">
                    <ul>
                        <li class="<?php echo e(isActive('user.dashboard')); ?>">
                            <a href="<?php echo e(route('user.dashboard')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M21 17.9668V10.1503C21 8.93937 20.4604 7.7925 19.5301 7.02652L14.5301 2.90935C13.0577 1.69688 10.9423 1.69689 9.46986 2.90935L4.46986 7.02652C3.53964 7.7925 3 8.93937 3 10.1503V17.9668C3 20.1943 4.79086 22 7 22H17C19.2091 22 21 20.1943 21 17.9668Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M7.25 12C7.25 11.5858 7.58579 11.25 8 11.25H16C16.4142 11.25 16.75 11.5858 16.75 12C16.75 12.4142 16.4142 12.75 16 12.75H8C7.58579 12.75 7.25 12.4142 7.25 12Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M7.25 16C7.25 15.5858 7.58579 15.25 8 15.25H16C16.4142 15.25 16.75 15.5858 16.75 16C16.75 16.4142 16.4142 16.75 16 16.75H8C7.58579 16.75 7.25 16.4142 7.25 16Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Dashboard')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.schema*')); ?>">
                            <a href="<?php echo e(route('user.schema')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M11.1718 21.6237L3.00221 17.9102C2.22062 17.555 2.22062 16.4448 3.00221 16.0895L11.1718 12.376C11.6976 12.137 12.3012 12.137 12.827 12.376L20.9966 16.0895C21.7782 16.4448 21.7782 17.555 20.9966 17.9102L12.827 21.6237C12.3012 21.8627 11.6976 21.8627 11.1718 21.6237Z"
                                        fill="white" />
                                    <path
                                        d="M11.1718 16.6237L3.00221 12.9102C2.22062 12.555 2.22062 11.4448 3.00221 11.0895L11.1718 7.37604C11.6976 7.13702 12.3012 7.13702 12.827 7.37604L20.9966 11.0895C21.7782 11.4448 21.7782 12.555 20.9966 12.9102L12.827 16.6237C12.3012 16.8627 11.6976 16.8627 11.1718 16.6237Z"
                                        fill="white" />
                                    <path opacity="0.4"
                                        d="M11.1718 11.6237L3.00221 7.91023C2.22062 7.55496 2.22062 6.44476 3.00221 6.08949L11.1718 2.37604C11.6976 2.13702 12.3012 2.13702 12.827 2.37604L20.9966 6.08949C21.7782 6.44476 21.7782 7.55496 20.9966 7.91023L12.827 11.6237C12.3012 11.8627 11.6976 11.8627 11.1718 11.6237Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('All Schemas')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.invest*')); ?>">
                            <a href="<?php echo e(route('user.invest-logs')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2 6.375V17.625C2 18.5414 2.35152 19.3725 2.9221 19.9806L6.27081 12.4224C6.96597 10.7973 8.51706 9.75 10.2287 9.75H19.3247V8.625C19.3247 6.76104 17.8704 5.25 16.0763 5.25H12.7227C12.1448 5.25 11.5773 5.0898 11.0788 4.78592L8.91049 3.46408C8.41201 3.1602 7.84453 3 7.26659 3H5.24839C3.45435 3 2 4.51104 2 6.375Z"
                                        fill="white" />
                                    <path opacity="0.4"
                                        d="M10.2285 9.75C8.51683 9.75 6.96574 10.7973 6.27058 12.4224L2.92188 19.9806C3.51188 20.6095 4.33613 21 5.24816 21H14.7066C16.228 21 17.6378 20.1707 18.4206 18.8152L21.6878 13.1576C22.5539 11.6579 21.5141 9.75 19.8308 9.75H10.2285Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Schema Logs')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.transactions*')); ?>">
                            <a href="<?php echo e(route('user.transactions')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M2 4C2 2.89543 2.89543 2 4 2H12C13.1046 2 14 2.89543 14 4V8C14 9.10457 13.1046 10 12 10H4C2.89543 10 2 9.10457 2 8V4Z"
                                        fill="white" />
                                    <path opacity="0.4"
                                        d="M10 16C10 14.8954 10.8954 14 12 14H20C21.1046 14 22 14.8954 22 16V20C22 21.1046 21.1046 22 20 22H12C10.8954 22 10 21.1046 10 20V16Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M20.6036 6.75L19.8839 7.46967C19.591 7.76256 19.591 8.23744 19.8839 8.53033C20.1768 8.82322 20.6517 8.82322 20.9445 8.53033L22.2374 7.23744C22.9209 6.55402 22.9209 5.44598 22.2374 4.76256L20.9445 3.46967C20.6517 3.17678 20.1768 3.17678 19.8839 3.46967C19.591 3.76256 19.591 4.23744 19.8839 4.53033L20.6036 5.25L16 5.25C15.5858 5.25 15.25 5.58579 15.25 6C15.25 6.41421 15.5858 6.75 16 6.75L20.6036 6.75Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M3.39645 18.75L4.11612 19.4697C4.40901 19.7626 4.40901 20.2374 4.11612 20.5303C3.82322 20.8232 3.34835 20.8232 3.05546 20.5303L1.76256 19.2374C1.07915 18.554 1.07914 17.446 1.76256 16.7626L3.05546 15.4697C3.34835 15.1768 3.82322 15.1768 4.11612 15.4697C4.40901 15.7626 4.40901 16.2374 4.11612 16.5303L3.39645 17.25L8 17.25C8.41421 17.25 8.75 17.5858 8.75 18C8.75 18.4142 8.41421 18.75 8 18.75L3.39645 18.75Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('All Transactions')); ?></span></a>
                        </li>
                        <li class="<?php if( Route::currentRouteName() != 'user.deposit.log'): ?> <?php echo e(isActive('user.deposit*')); ?> <?php endif; ?>">
                            <a href="<?php echo e(route('user.deposit.amount')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M12 5.75C12.4142 5.75 12.75 6.08579 12.75 6.5V7.35352C13.9043 7.67998 14.75 8.74122 14.75 10C14.75 10.4142 14.4142 10.75 14 10.75C13.5858 10.75 13.25 10.4142 13.25 10C13.25 9.30964 12.6904 8.75 12 8.75C11.3096 8.75 10.75 9.30964 10.75 10C10.75 10.6904 11.3096 11.25 12 11.25C13.5188 11.25 14.75 12.4812 14.75 14C14.75 15.2588 13.9043 16.32 12.75 16.6465V17.5C12.75 17.9142 12.4142 18.25 12 18.25C11.5858 18.25 11.25 17.9142 11.25 17.5V16.6465C10.0957 16.32 9.25 15.2588 9.25 14C9.25 13.5858 9.58579 13.25 10 13.25C10.4142 13.25 10.75 13.5858 10.75 14C10.75 14.6904 11.3096 15.25 12 15.25C12.6904 15.25 13.25 14.6904 13.25 14C13.25 13.3096 12.6904 12.75 12 12.75C10.4812 12.75 9.25 11.5188 9.25 10C9.25 8.74122 10.0957 7.67998 11.25 7.35352V6.5C11.25 6.08579 11.5858 5.75 12 5.75Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Add Money')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.deposit.log')); ?>">
                            <a href="<?php echo e(route('user.deposit.log')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M20 13C20 17.9706 15.9706 22 11 22C6.02944 22 2 17.9706 2 13C2 8.02944 6.02944 4 11 4C15.9706 4 20 8.02944 20 13Z"
                                        fill="white" />
                                    <path
                                        d="M21.8025 10.0128C21.0104 6.08419 17.9158 2.98956 13.9872 2.19745C12.9045 1.97914 12 2.89543 12 4V10C12 11.1046 12.8954 12 14 12H20C21.1046 12 22.0209 11.0955 21.8025 10.0128Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Add Money Log')); ?></span></a>
                        </li>
                        <li class="<?php echo e(isActive('user.wallet-exchange')); ?>">
                            <a href="<?php echo e(route('user.wallet-exchange')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd"
                                        d="M12 5.75C12.4142 5.75 12.75 6.08579 12.75 6.5V7.35352C13.9043 7.67998 14.75 8.74122 14.75 10C14.75 10.4142 14.4142 10.75 14 10.75C13.5858 10.75 13.25 10.4142 13.25 10C13.25 9.30964 12.6904 8.75 12 8.75C11.3096 8.75 10.75 9.30964 10.75 10C10.75 10.6904 11.3096 11.25 12 11.25C13.5188 11.25 14.75 12.4812 14.75 14C14.75 15.2588 13.9043 16.32 12.75 16.6465V17.5C12.75 17.9142 12.4142 18.25 12 18.25C11.5858 18.25 11.25 17.9142 11.25 17.5V16.6465C10.0957 16.32 9.25 15.2588 9.25 14C9.25 13.5858 9.58579 13.25 10 13.25C10.4142 13.25 10.75 13.5858 10.75 14C10.75 14.6904 11.3096 15.25 12 15.25C12.6904 15.25 13.25 14.6904 13.25 14C13.25 13.3096 12.6904 12.75 12 12.75C10.4812 12.75 9.25 11.5188 9.25 10C9.25 8.74122 10.0957 7.67998 11.25 7.35352V6.5C11.25 6.08579 11.5858 5.75 12 5.75Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M3.88648 8.71859C5.18395 5.51328 8.32685 3.25 12.0002 3.25C16.351 3.25 19.9602 6.42553 20.6364 10.5853L21.5502 9.9C21.8815 9.65147 22.3516 9.71863 22.6002 10.05C22.8487 10.3814 22.7815 10.8515 22.4502 11.1L21.439 11.8584C20.6057 12.4833 19.4908 12.5839 18.5592 12.118L17.6648 11.6708C17.2943 11.4856 17.1441 11.0351 17.3293 10.6646C17.5146 10.2941 17.9651 10.1439 18.3356 10.3292L19.1395 10.7311C18.5395 7.33207 15.5714 4.75 12.0002 4.75C8.95872 4.75 6.35296 6.62306 5.27689 9.28141C5.12147 9.66536 4.68422 9.85062 4.30027 9.6952C3.91632 9.53978 3.73106 9.10254 3.88648 8.71859ZM3.32897 13.1794C3.29555 13.1926 3.26253 13.2073 3.23 13.2236L2.33557 13.6708C1.96509 13.8561 1.51459 13.7059 1.32934 13.3354C1.1441 12.9649 1.29427 12.5144 1.66475 12.3292L2.55918 11.882C3.49084 11.4161 4.60572 11.5167 5.43902 12.1416L6.45016 12.9C6.78154 13.1485 6.84869 13.6186 6.60016 13.95C6.35164 14.2814 5.88154 14.3485 5.55016 14.1L4.93635 13.6396C5.67946 16.8539 8.56 19.25 12.0002 19.25C15.0416 19.25 17.6474 17.3769 18.7234 14.7186C18.8789 14.3346 19.3161 14.1494 19.7001 14.3048C20.084 14.4602 20.2693 14.8975 20.1139 15.2814C18.8164 18.4867 15.6735 20.75 12.0002 20.75C7.56763 20.75 3.90489 17.4541 3.32897 13.1794Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Wallet Exchange')); ?></span>
                            </a>
                        </li>
                        <li class="<?php if( Route::currentRouteName() != 'user.send-money.log'): ?> <?php echo e(isActive('user.send-money*')); ?> <?php endif; ?>">
                            <a href="<?php echo e(route('user.send-money.view')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M19 13C19 17.4183 15.4183 21 11 21C6.58172 21 3 17.4183 3 13C3 8.58172 6.58172 5 11 5C15.4183 5 19 8.58172 19 13Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M16 3.75C15.5858 3.75 15.25 3.41421 15.25 3C15.25 2.58579 15.5858 2.25 16 2.25H21C21.4142 2.25 21.75 2.58579 21.75 3V8C21.75 8.41421 21.4142 8.75 21 8.75C20.5858 8.75 20.25 8.41421 20.25 8V4.81066L10.5303 14.5303C10.2374 14.8232 9.76256 14.8232 9.46967 14.5303C9.17678 14.2374 9.17678 13.7626 9.46967 13.4697L19.1893 3.75H16Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Send Money')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.send-money.log')); ?>">
                            <a href="<?php echo e(route('user.send-money.log')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6 12H8C10.2091 12 12 13.7909 12 16V18C12 20.2091 10.2091 22 8 22H6C3.79086 22 2 20.2091 2 18V16C2 13.7909 3.79086 12 6 12Z"
                                        fill="white" />
                                    <path opacity="0.4"
                                        d="M10 2H18C20.2091 2 22 3.79086 22 6V14C22 16.2091 20.2091 18 18 18H10C7.79086 18 6 16.2091 6 14V6C6 3.79086 7.79086 2 10 2Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M11.25 7C11.25 6.58579 11.5858 6.25 12 6.25H17C17.4142 6.25 17.75 6.58579 17.75 7V12C17.75 12.4142 17.4142 12.75 17 12.75C16.5858 12.75 16.25 12.4142 16.25 12V8.81066L10.5303 14.5303C10.2374 14.8232 9.76256 14.8232 9.46967 14.5303C9.17678 14.2374 9.17678 13.7626 9.46967 13.4697L15.1893 7.75H12C11.5858 7.75 11.25 7.41421 11.25 7Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Send Money Log')); ?></span>
                            </a>
                        </li>
                        <li class="<?php if( Route::currentRouteName() != 'user.withdraw.log'): ?> <?php echo e(isActive('user.withdraw*')); ?> <?php endif; ?>">
                            <a href="<?php echo e(route('user.withdraw.view')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M4 12C4 10.8954 4.89543 10 6 10H15C16.1046 10 17 10.8954 17 12C17 13.1046 16.1046 14 15 14H6C4.89543 14 4 13.1046 4 12Z"
                                        fill="white" />
                                    <path
                                        d="M15 14H6.16667C4.97005 14 4 14.8954 4 16C4 17.1046 4.97005 18 6.16667 18H15C16.1046 18 17 17.1046 17 16C17 14.8954 16.1046 14 15 14Z"
                                        fill="white" />
                                    <path opacity="0.4"
                                        d="M20 18C20 15.7909 18.2091 14 16 14C15.8007 14 15.6047 14.0146 15.4132 14.0427C13.4823 14.3266 12 15.9902 12 18C12 20.2091 13.7909 22 16 22C18.2091 22 20 20.2091 20 18Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M11.25 3.39645L10.5303 4.11612C10.2374 4.40901 9.76256 4.40901 9.46967 4.11612C9.17678 3.82322 9.17678 3.34835 9.46967 3.05546L10.7626 1.76256C11.446 1.07915 12.554 1.07914 13.2374 1.76256L14.5303 3.05546C14.8232 3.34835 14.8232 3.82322 14.5303 4.11612C14.2374 4.40901 13.7626 4.40901 13.4697 4.11612L12.75 3.39645L12.75 7C12.75 7.41421 12.4142 7.75 12 7.75C11.5858 7.75 11.25 7.41421 11.25 7L11.25 3.39645Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Withdraw')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.withdraw.log')); ?>">
                            <a href="<?php echo e(route('user.withdraw.log')); ?>"><svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M18 4C19.1046 4 20 4.89543 20 6C20 7.10457 19.1046 8 18 8L10 8C8.89543 8 8 7.10457 8 6C8 4.89543 8.89543 4 10 4L18 4Z"
                                        fill="white" />
                                    <path opacity="0.4"
                                        d="M18 12C19.1046 12 20 12.8954 20 14C20 15.1046 19.1046 16 18 16L10 16C8.89543 16 8 15.1046 8 14C8 12.8954 8.89543 12 10 12L18 12Z"
                                        fill="white" />
                                    <rect x="16" y="8" width="4" height="12" rx="2" transform="rotate(90 16 8)"
                                        fill="white" />
                                    <rect x="17" y="16" width="4" height="12" rx="2" transform="rotate(90 17 16)"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Withdraw Log')); ?></span>
                            </a>
                        </li>
                        <?php if(setting('user_reward','permission')): ?>
                        <li class="<?php echo e(isActive('user.ranking-badge')); ?>">
                            <a href="<?php echo e(route('user.ranking-badge')); ?>"><svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M17 10.101V4C17 2.89543 16.1046 2 15 2H9C7.89543 2 7 2.89543 7 4V10.101C8.27052 8.80447 10.0413 8 12 8C13.9587 8 15.7295 8.80447 17 10.101Z"
                                        fill="white" />
                                    <circle opacity="0.4" cx="12" cy="15" r="7" fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M22.5303 9.46967C22.8232 9.76256 22.8232 10.2374 22.5303 10.5303L21.5303 11.5303C21.2374 11.8232 20.7626 11.8232 20.4697 11.5303C20.1768 11.2374 20.1768 10.7626 20.4697 10.4697L21.4697 9.46967C21.7626 9.17678 22.2374 9.17678 22.5303 9.46967Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M20.4697 18.4697C20.7626 18.1768 21.2374 18.1768 21.5303 18.4697L22.5303 19.4697C22.8232 19.7626 22.8232 20.2374 22.5303 20.5303C22.2374 20.8232 21.7626 20.8232 21.4697 20.5303L20.4697 19.5303C20.1768 19.2374 20.1768 18.7626 20.4697 18.4697Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M1.46967 9.46967C1.17678 9.76256 1.17678 10.2374 1.46967 10.5303L2.46967 11.5303C2.76256 11.8232 3.23744 11.8232 3.53033 11.5303C3.82322 11.2374 3.82322 10.7626 3.53033 10.4697L2.53033 9.46967C2.23744 9.17678 1.76256 9.17678 1.46967 9.46967Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M3.53033 18.4697C3.23744 18.1768 2.76256 18.1768 2.46967 18.4697L1.46967 19.4697C1.17678 19.7626 1.17678 20.2374 1.46967 20.5303C1.76256 20.8232 2.23744 20.8232 2.53033 20.5303L3.53033 19.5303C3.82322 19.2374 3.82322 18.7626 3.53033 18.4697Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M12.3945 11.362C12.6156 11.4987 12.7502 11.7401 12.7502 12V17.25H13.0002C13.4144 17.25 13.7502 17.5858 13.7502 18C13.7502 18.4142 13.4144 18.75 13.0002 18.75H11.0002C10.586 18.75 10.2502 18.4142 10.2502 18C10.2502 17.5858 10.586 17.25 11.0002 17.25H11.2502V13.2072C10.8984 13.3321 10.5006 13.1778 10.3293 12.8354C10.1441 12.4649 10.2943 12.0144 10.6648 11.8292L11.6648 11.3292C11.8972 11.2129 12.1734 11.2254 12.3945 11.362Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Ranking Badge')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(setting('sign_up_referral', 'permission')): ?>
                        <li class=" <?php echo e(isActive('user.referral')); ?>">
                            <a href="<?php echo e(route('user.referral')); ?>"><svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M20 11C20 6.02944 15.9706 2 11 2C6.02944 2 2 6.02944 2 11C2 15.9706 6.02944 20 11 20C15.9706 20 20 15.9706 20 11Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M10.8694 13.75C9.79795 13.753 8.7328 14.0456 7.30683 14.6844C6.92882 14.8538 6.4851 14.6847 6.31574 14.3066C6.14638 13.9286 6.31553 13.4849 6.69354 13.3156C8.21341 12.6346 9.49813 12.2538 10.8652 12.25C12.2263 12.2463 13.5951 12.6166 15.2836 13.3056C15.6671 13.4621 15.8511 13.8999 15.6946 14.2834C15.5381 14.6669 15.1003 14.8509 14.7168 14.6944C13.105 14.0366 11.9468 13.747 10.8694 13.75Z"
                                        fill="white" />
                                    <circle cx="3" cy="3" r="3" transform="matrix(1 0 0 -1 8 11)" fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M18.75 16C18.75 15.5858 18.4142 15.25 18 15.25C17.5858 15.25 17.25 15.5858 17.25 16V17.25H16C15.5858 17.25 15.25 17.5858 15.25 18C15.25 18.4142 15.5858 18.75 16 18.75H17.25V20C17.25 20.4142 17.5858 20.75 18 20.75C18.4142 20.75 18.75 20.4142 18.75 20V18.75H20C20.4142 18.75 20.75 18.4142 20.75 18C20.75 17.5858 20.4142 17.25 20 17.25H18.75V16Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Referral')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(setting('user_reward', 'permission') && auth()->user()->reward_status): ?>
                        <li class=" <?php echo e(isActive('user.rewards*')); ?>">
                            <a href="<?php echo e(route('user.rewards.index')); ?>"><svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                                             xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                          d="M20 11C20 6.02944 15.9706 2 11 2C6.02944 2 2 6.02944 2 11C2 15.9706 6.02944 20 11 20C15.9706 20 20 15.9706 20 11Z"
                                          fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M10.8694 13.75C9.79795 13.753 8.7328 14.0456 7.30683 14.6844C6.92882 14.8538 6.4851 14.6847 6.31574 14.3066C6.14638 13.9286 6.31553 13.4849 6.69354 13.3156C8.21341 12.6346 9.49813 12.2538 10.8652 12.25C12.2263 12.2463 13.5951 12.6166 15.2836 13.3056C15.6671 13.4621 15.8511 13.8999 15.6946 14.2834C15.5381 14.6669 15.1003 14.8509 14.7168 14.6944C13.105 14.0366 11.9468 13.747 10.8694 13.75Z"
                                          fill="white" />
                                    <circle cx="3" cy="3" r="3" transform="matrix(1 0 0 -1 8 11)" fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M18.75 16C18.75 15.5858 18.4142 15.25 18 15.25C17.5858 15.25 17.25 15.5858 17.25 16V17.25H16C15.5858 17.25 15.25 17.5858 15.25 18C15.25 18.4142 15.5858 18.75 16 18.75H17.25V20C17.25 20.4142 17.5858 20.75 18 20.75C18.4142 20.75 18.75 20.4142 18.75 20V18.75H20C20.4142 18.75 20.75 18.4142 20.75 18C20.75 17.5858 20.4142 17.25 20 17.25H18.75V16Z"
                                          fill="white" />
                                </svg>
                                <span><?php echo e(__('Rewards')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="separator"></li>
                        <li class="<?php echo e(isActive('user.setting*')); ?>">
                            <a href="<?php echo e(route('user.setting.show')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M12.9545 3H11.0455C9.99109 3 9.13635 3.80589 9.13635 4.8C9.13635 5.93761 7.91917 6.66087 6.92 6.11697L6.81852 6.06172C5.90541 5.56467 4.73782 5.85964 4.21064 6.72057L3.25609 8.27942C2.72891 9.14034 3.04176 10.2412 3.95487 10.7383C4.95451 11.2824 4.95451 12.7176 3.95487 13.2617C3.04176 13.7588 2.72891 14.8597 3.25609 15.7206L4.21064 17.2794C4.73782 18.1404 5.90541 18.4353 6.81851 17.9383L6.92 17.883C7.91917 17.3391 9.13635 18.0624 9.13635 19.2C9.13635 20.1941 9.99109 21 11.0455 21H12.9545C14.0089 21 14.8636 20.1941 14.8636 19.2C14.8636 18.0624 16.0808 17.3391 17.08 17.883L17.1815 17.9383C18.0946 18.4353 19.2622 18.1403 19.7894 17.2794L20.7439 15.7206C21.2711 14.8596 20.9582 13.7588 20.0451 13.2617C19.0455 12.7176 19.0455 11.2824 20.0451 10.7383C20.9582 10.2412 21.2711 9.14036 20.7439 8.27943L19.7894 6.72058C19.2622 5.85966 18.0946 5.56468 17.1815 6.06174L17.08 6.11698C16.0808 6.66088 14.8636 5.93762 14.8636 4.8C14.8636 3.80589 14.0089 3 12.9545 3Z"
                                        fill="white" />
                                    <circle cx="12" cy="12" r="3" fill="white" />
                                </svg>
                                <span><?php echo e(__('Settings')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.ticket*')); ?>">
                            <a href="<?php echo e(route('user.ticket.index')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M10.7188 16.5889L13.6905 21.2421C14.1205 21.9154 15.0042 22.1311 15.696 21.7316C16.4363 21.3042 16.6675 20.3438 16.2029 19.6263L13.7755 15.8779L10.7188 16.5889Z"
                                        fill="white" />
                                    <path opacity="0.4"
                                        d="M12.5125 3.98368C13.4284 2.99791 15.0369 3.17971 15.7097 4.34505L20.0017 11.7792C20.6746 12.9445 20.0278 14.4283 18.7161 14.7287L7.79879 17.268L4.79879 12.0718L12.5125 3.98368Z"
                                        fill="white" />
                                    <path
                                        d="M7.84766 16.7273L5.34766 12.3972C4.93344 11.6797 4.01606 11.4339 3.29862 11.8481C2.58118 12.2624 2.33537 13.1797 2.74958 13.8972L5.24958 18.2273C5.66379 18.9447 6.58118 19.1906 7.29862 18.7763C8.01606 18.3621 8.26187 17.4447 7.84766 16.7273Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M20.0143 2.73953C20.4144 2.84673 20.6519 3.25799 20.5447 3.65809L20.1787 5.02411C20.0714 5.42421 19.6602 5.66165 19.2601 5.55444C18.86 5.44724 18.6226 5.03598 18.7298 4.63588L19.0958 3.26986C19.203 2.86976 19.6142 2.63232 20.0143 2.73953Z"
                                        fill="white" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M20.7298 8.10018C20.837 7.70008 21.2482 7.46264 21.6483 7.56985L23.0143 7.93588C23.4144 8.04308 23.6519 8.45433 23.5447 8.85443C23.4375 9.25453 23.0262 9.49197 22.6261 9.38476L21.2601 9.01874C20.86 8.91153 20.6226 8.50028 20.7298 8.10018Z"
                                        fill="white" />
                                </svg>
                                <span><?php echo e(__('Support Tickets')); ?></span>
                            </a>
                        </li>
                        <li class="<?php echo e(isActive('user.notification*')); ?>">
                            <a href="<?php echo e(route('user.notification.all')); ?>">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12 21C13.385 21 14.5633 20.1652 15 19H9C9.43668 20.1652 10.615 21 12 21Z"
                                        fill="white" />
                                    <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd"
                                        d="M13.6896 3.75403C13.274 3.29116 12.671 3 12 3C10.7463 3 9.73005 4.01629 9.73005 5.26995V5.37366C7.58766 6.10719 6.0016 7.85063 5.76046 9.97519L5.31328 13.9153C5.23274 14.6249 4.93344 15.3016 4.44779 15.8721C3.35076 17.1609 4.39443 19 6.22281 19H17.7772C19.6056 19 20.6492 17.1609 19.5522 15.8721C19.0666 15.3016 18.7673 14.6249 18.6867 13.9153L18.2395 9.97519C18.2333 9.92024 18.2262 9.86556 18.2181 9.81113C17.8341 9.93379 17.4248 10 17 10C14.7909 10 13 8.20914 13 6C13 5.16744 13.2544 4.3943 13.6896 3.75403Z"
                                        fill="white" />
                                    <circle cx="17" cy="6" r="3" fill="white" />
                                </svg>
                                <span><?php echo e(__('Notification')); ?></span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>
        <div class="rock-sidebar-logout">
            <a class="submit" href="#"  onclick="event.preventDefault(); localStorage.clear();  $('#logout-form').submit();">
                <span>
                    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.4"
                            d="M7.5 3H11.5C13.7091 3 15.5 4.79086 15.5 7V17C15.5 19.2091 13.7091 21 11.5 21H7.5C5.29086 21 3.5 19.2091 3.5 17V7C3.5 4.79086 5.29086 3 7.5 3Z"
                            fill="white" />
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M17.9697 8.46967C18.2626 8.17678 18.7374 8.17678 19.0303 8.46967L22.0303 11.4697C22.3232 11.7626 22.3232 12.2374 22.0303 12.5303L19.0303 15.5303C18.7374 15.8232 18.2626 15.8232 17.9697 15.5303C17.6768 15.2374 17.6768 14.7626 17.9697 14.4697L19.6893 12.75H9.5C9.08579 12.75 8.75 12.4142 8.75 12C8.75 11.5858 9.08579 11.25 9.5 11.25H19.6893L17.9697 9.53033C17.6768 9.23744 17.6768 8.76256 17.9697 8.46967Z"
                            fill="white" />
                    </svg>
                </span>
                <?php echo e(__('Logout')); ?>

            </a>
        </div>
    </div>
</div>
<!-- Page Sidebar Ends-->
<?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/investify/include/__user_side_nav.blade.php ENDPATH**/ ?>