
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Manage Referral')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Target Referrals')); ?></h2>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('target-manage')): ?>
                                <div class="card-header-links">
                                    <a href="<?php echo e(route('admin.referral.target')); ?>"
                                       class="title-btn"><?php echo e(__('Set Targets')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6 col-md-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Investment Bounty')); ?></h3>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-create')): ?>
                                <div class="card-header-links">
                                    <button class="card-header-link new-referral" type="button"
                                            data-type="investment"><?php echo e(__('Add New')); ?></button>
                                </div>
                            <?php endif; ?>

                        </div>
                        <div class="site-card-body">
                            <p class="paragraph"><?php echo e(__('You can')); ?>

                                <strong><?php echo e(__('Add').','. __('Edit').' '. __('or').' '. __('Delete')); ?></strong> <?php echo e(__('any of the')); ?>

                                <strong><?php echo e(__('Referred User Investment Bounty')); ?></strong></p>


                            <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single-gateway">
                                    <div class="gateway-name">
                                        <div class="gateway-title">
                                            <h4><?php echo e($investment->target->name); ?></h4>
                                            <p><?php echo e($investment->description); ?></p>
                                        </div>
                                    </div>
                                    <div class="gateway-right">
                                        <div class="gateway-status">
                                            <div class="site-badge success"><?php echo e($investment->bounty); ?>%</div>
                                        </div>
                                        <div class="gateway-edit">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-edit')): ?>
                                                <a href="" type="button" class="edit-referral"
                                                   data-id="<?php echo e($investment->id); ?>"
                                                   data-type="<?php echo e($investment->type); ?>"
                                                   data-target="<?php echo e($investment->referral_target_id); ?>"
                                                   data-target-amount="<?php echo e($investment->target_amount); ?>"
                                                   data-bounty="<?php echo e($investment->bounty); ?>"
                                                   data-description="<?php echo e($investment->description); ?>"
                                                ><i icon-name="edit-3"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-delete')): ?>
                                                <a href="" class="red-bg ms-2 delete-referral" type="button"
                                                   data-id="<?php echo e($investment->id); ?>"
                                                   data-target="<?php echo e($investment->target->name); ?>"
                                                ><i icon-name="trash-2"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-md-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Deposit Bounty')); ?></h3>
                            <div class="card-header-links">
                                <button class="card-header-link new-referral" type="button"
                                        data-type="deposit"><?php echo e(__('Add New')); ?></button>
                            </div>
                        </div>
                        <div class="site-card-body">
                            <p class="paragraph"><?php echo e(__('You can')); ?>

                                <strong><?php echo e(__('Add').','. __('Edit').' '. __('or').' '. __('Delete')); ?></strong> <?php echo e(__('any of the')); ?>

                                <strong><?php echo e(__('Referred User Deposit Bounty')); ?></strong></p>
                            <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <div class="single-gateway">
                                    <div class="gateway-name">
                                        <div class="gateway-title">
                                            <h4><?php echo e($deposit->target->name); ?></h4>
                                            <p><?php echo e($deposit->description); ?></p>
                                        </div>
                                    </div>
                                    <div class="gateway-right">
                                        <div class="gateway-status">
                                            <div class="site-badge success"><?php echo e($deposit->bounty .''.__('%')); ?></div>
                                        </div>
                                        <div class="gateway-edit">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-edit')): ?>
                                                <a href="" type="button" class="edit-referral"
                                                   data-id="<?php echo e($deposit->id); ?>"
                                                   data-type="<?php echo e($deposit->type); ?>"
                                                   data-target="<?php echo e($deposit->referral_target_id); ?>"
                                                   data-target-amount="<?php echo e($deposit->target_amount); ?>"
                                                   data-bounty="<?php echo e($deposit->bounty); ?>"
                                                   data-description="<?php echo e($deposit->description); ?>"
                                                ><i icon-name="edit-3"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-delete')): ?>
                                                <a href="" class="red-bg ms-2 delete-referral" type="button"
                                                   data-id="<?php echo e($deposit->id); ?>"
                                                   data-target="<?php echo e($deposit->target->name); ?>"
                                                ><i icon-name="trash-2"></i></a>
                                            <?php endif; ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for Add New Level -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-create')): ?>
            <?php echo $__env->make('backend.referral.include.__new_referral', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Add New Level-->

        <!-- Modal for Edit Level -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-edit')): ?>
            <?php echo $__env->make('backend.referral.include.__edit_referral', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Edit Level-->

        <!-- Modal for Delete Level -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-delete')): ?>
            <?php echo $__env->make('backend.referral.include.__delete_referral', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Delete Level End-->

        <?php $__env->stopSection(); ?>
        <?php $__env->startSection('script'); ?>
            <script>

                $('.new-referral').on('click', function (e) {
                    "use strict";
                    e.preventDefault();
                    var type = $(this).data('type');
                    $('.referral-type').val(type);
                    $('#addNewReferral').modal('show');

                })

                $('.edit-referral').on('click', function (e) {
                    "use strict";
                    e.preventDefault();
                    var id = $(this).data('id');
                    var type = $(this).data('type');
                    var target = $(this).data('target');
                    var targetAmount = $(this).data('target-amount');
                    var bounty = $(this).data('bounty');
                    var description = $(this).data('description');


                    $('.referral-id').val(id);
                    $('.referral-type').val(type);
                    $('.target_id').val(target);
                    $('.target-amount').val(targetAmount);
                    $('.bounty').val(bounty);
                    $('.description').val(description);

                    $('#editReferral').modal('show');

                })
                $('.delete-referral').on('click', function (e) {
                    "use strict";
                    e.preventDefault();
                    var id = $(this).data('id');
                    var target = $(this).data('target');
                    $('.referral-id').val(id);
                    $('.target').html(target);
                    $('#deleteReferral').modal('show');

                })

            </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/referral/index.blade.php ENDPATH**/ ?>