
<?php $__env->startSection('setting-title'); ?>
    <?php echo e(__('Push Notification Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Notification Settings')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('setting-content'); ?>
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
        <div class="site-card">
            <div class="site-card-header d-flex">
                <h3 class="title"><?php echo e(__('Notification Tune Settings')); ?></h3>

                <div class="card-header-links">
                    <a href="<?php echo e(route('admin.settings.plugin','notification')); ?>" class="card-header-link new-referral"
                       type="button" data-type="investment">
                        <i icon-name="corner-down-left"></i><?php echo e(__('Back')); ?></a>
                </div>
            </div>
            <div class="site-card-body">
                <?php $__currentLoopData = $set_tunes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $set_tune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-gateway">
                        <div class="gateway-name">
                            <div class="gateway-icon">
                                <img
                                    src="<?php echo e(asset($set_tune->icon)); ?>" alt=""/>
                            </div>
                            <div class="gateway-title">
                                <h4><?php echo e($set_tune->name); ?></h4>
                            </div>
                        </div>
                        <div class="gateway-right">
                            <div class="gateway-status m-0 me-2">
                                <button type="button" value="<?php echo e($set_tune->id); ?>"
                                        data-tune-preview="<?php echo e(asset($set_tune->tune)); ?>"
                                        class="site-btn-xs primary-btn audioPlay">
                                    <span class="play-<?php echo e($set_tune->id); ?> play"> <i class="play"
                                                                                  icon-name="play"></i></span>
                                    <span class="stop-<?php echo e($set_tune->id); ?> hidden stop"> <i icon-name="pause"></i></span>
                                    <span class="tune-status-<?php echo e($set_tune->id); ?> status-text"><?php echo e(__('Play')); ?></span>
                                </button>
                            </div>
                            <div class="gateway-status m-0">
                                <?php if($set_tune->status == true): ?>
                                    <a href="<?php echo e(route('admin.settings.notification.tune.status', $set_tune->id)); ?>"
                                       class="site-btn-xs green-btn"><i icon-name="check"></i><?php echo e(__('Active in')); ?></a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('admin.settings.notification.tune.status', $set_tune->id)); ?>"
                                       class="site-btn-xs red-btn"><i icon-name="x"></i><?php echo e(__('Inactive')); ?></a>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function ($) {
            'use strict';
            var audio;
            var isPlaying = false;
            var oldTuneSrc = null
            $('.audioPlay').on('click', function (e) {
                e.preventDefault();
                var id = $(this).val();
                $('.stop').addClass('hidden');
                $('.play').removeClass('hidden');

                let tunePreview = $(this).data('tune-preview');
                var tuneStatus = $('.tune-status-' + $(this).val());
                var status = tuneStatus.text();

                if (status === 'Play') {
                    if (isPlaying && tunePreview === oldTuneSrc) {
                        $('.play-' + $(this).val()).addClass('hidden');
                        $('.stop-' + $(this).val()).removeClass('hidden');
                        tuneStatus.text('Stop');
                        audio.pause();
                        audio.currentTime = 0;

                    } else {
                        $('.play-' + $(this).val()).addClass('hidden');
                        $('.stop-' + $(this).val()).removeClass('hidden');

                        $('.status-text').text('Play');
                        tuneStatus.text('Stop');

                        if (audio) {
                            audio.pause();
                            audio.currentTime = 0;
                        }
                        audio = new Audio(tunePreview);

                        $(audio).on('ended', function () {
                            tuneStatus.text('Play');
                            $('.play-' + id).removeClass('hidden');
                            $('.stop-' + id).addClass('hidden');
                            isPlaying = false;
                        });

                        audio.play();
                        isPlaying = true;
                        oldTuneSrc = tunePreview
                    }

                } else if (status === 'Stop') {
                    $('.play-' + $(this).val()).removeClass('hidden');
                    $('.stop-' + $(this).val()).addClass('hidden');
                    audio.pause();
                    audio.currentTime = 0;
                    tuneStatus.text('Play');
                    isPlaying = false;
                }
            })

        })(jQuery)
    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.setting.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/setting/notification_tune/index.blade.php ENDPATH**/ ?>