
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Deposit History')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('deposit_content'); ?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="site-table table-responsive">
                    <form action="<?php echo e(request()->url()); ?>" method="get">
                        <div class="table-filter d-flex justify-content-between">
                            <div class="filter d-flex">
                                <div class="search">
                                    <input type="text" id="search" name="query" value="<?php echo e(request('query')); ?>" placeholder="Search" />
                                </div>
                                <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                            </div>
                            <div class="filter d-flex">
                                <select class="form-select form-select-sm" name="status" aria-label=".form-select-sm example">
                                    <option value="" selected><?php echo e(__('Filter By Status')); ?></option>
                                    <option value="success" <?php echo e(request('status') == 'success' ? 'selected' : ''); ?>><?php echo e(__('Success')); ?></option>
                                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>><?php echo e(__('Pending')); ?></option>
                                    <option value="failed" <?php echo e(request('status') == 'failed' ? 'selected' : ''); ?>><?php echo e(__('Failed')); ?></option>
                                </select>
                            </div>
                        </div>
                    </form>
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Transaction ID')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Charge')); ?></th>
                            <th><?php echo e(__('Gateway')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($history->created_at); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__user', ['item' => $history], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($history->tnx); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_amount', ['item' => $history], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($history->charge . ' ' . setting('site_currency', 'global')); ?></td>
                                <td><?php echo e($history->method); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_status', ['status' => $history->status], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                        <?php endif; ?>
                        </tbody>
                    </table>
                    <?php echo e($histories->links('backend.include.__pagination')); ?>

                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.deposit.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/deposit/history.blade.php ENDPATH**/ ?>