

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Register')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Authentication section start -->
    <section class="td-authentication-section">
        <div class="container">
            <div class="row gy-60 align-items-center">
                <div class="col-xxl-6 col-xl-6 col-lg-6 order-lg-last">
                    <div class="auth-from-main p-0">
                        <div class="auth-intro-content mb-40">
                            <h2 class="title"><?php echo e(__('Register')); ?></h2>
                        </div>
                        <div class="auth-from-box">
                            <?php if($errors->any()): ?>
                                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <strong><?php echo e($error); ?></strong>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            <?php endif; ?>
                            <form id="login-form" action="<?php echo e(route('register')); ?>" method="POST" novalidate
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row gy-15">
                                    <div class="col-lg-6">
                                        <div class="td-form-group has-right-icon">
                                            <label class="input-label"><?php echo e(__('First Name')); ?> <span>*</span></label>
                                            <div class="input-field">
                                                <input type="text" name="first_name" class="form-control"
                                                    value="<?php echo e(old('first_name')); ?>" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="td-form-group has-right-icon">
                                            <label class="input-label"><?php echo e(__('Last Name')); ?> <span>*</span></label>
                                            <div class="input-field">
                                                <input type="text" name="last_name" class="form-control"
                                                    placeholder="<?php echo e(__('Last Name')); ?>" required
                                                    value="<?php echo e(old('last_name')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-12">
                                        <div class="td-form-group">
                                            <label class="input-label"><?php echo e(__('Email Address')); ?><span>*</span></label>
                                            <div class="input-field">
                                                <input type="email" name="email" class="form-control"
                                                    placeholder="<?php echo e(__('Email Address')); ?>" required
                                                    value="<?php echo e(old('email')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(getPageSetting('username_show')): ?>
                                        <div class="col-lg-6">
                                            <div class="td-form-group has-right-icon">
                                                <label class="input-label"><?php echo e(__('Username')); ?> <span>*</span></label>
                                                <div class="input-field">
                                                    <input type="text" name="username" class="form-control"
                                                        placeholder="<?php echo e(__('Username')); ?>" required
                                                        value="<?php echo e(old('username')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(getPageSetting('country_show')): ?>
                                        <div class="col-lg-6">
                                            <div class="td-form-group">
                                                <label class="input-label">Country <span>*</span></label>
                                                <div class="input-field">
                                                    <select id="select2Icons" name="country"
                                                        class="select2-icons form-select">
                                                        <?php $__currentLoopData = getCountries(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php if($location->country_code == $country['code']): ?> selected <?php endif; ?>
                                                                value="<?php echo e($country['name'] . ':' . $country['dial_code']); ?>">
                                                                <?php echo e($country['name']); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(getPageSetting('phone_show')): ?>
                                        <div class="col-lg-6">
                                            <div class="td-form-group">
                                                <label class="input-label"><?php echo e(__('Phone Number')); ?></label>
                                                <div class="input-field input-group">
                                                    <span class="input-group-text"><?php echo e(getLocation()->dial_code); ?></span>
                                                    <input class="form-control" type="text" name="phone"
                                                        placeholder="<?php echo e(__('Phone Number')); ?>"
                                                        value="<?php echo e(old('phone')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(getPageSetting('referral_code_show')): ?>
                                        <div class="col-lg-6">
                                            <div class="td-form-group">
                                                <label class="input-label"><?php echo e(__('Referral Code')); ?> <span>*</span></label>
                                                <div class="input-field">
                                                    <input type="text" name="invite" class="form-control"
                                                        placeholder="<?php echo e(__('Referral Code')); ?>"
                                                        value="<?php echo e(request('invite') ?? old('invite')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(getPageSetting('register_custom_fields')): ?>
                                        <?php
                                            $customFields = json_decode(getPageSetting('register_custom_fields'), true);
                                        ?>
                                        <?php $__currentLoopData = $customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-6">
                                                <div class="td-form-group">
                                                    <label class="input-label" for=""><?php echo e($field['name']); ?>

                                                        <?php if($field['validation'] == 'required'): ?>
                                                            <span class="text-danger">*</span>
                                                        <?php endif; ?>
                                                    </label>
                                                    <?php if($field['type'] == 'textarea'): ?>
                                                        <div class="input-field">
                                                            <textarea name="custom_fields_data[<?php echo e($field['name']); ?>]" class="form-control" rows="3"
                                                                <?php if($field['validation'] == 'required'): ?> required <?php endif; ?>></textarea>
                                                        </div>
                                                    <?php elseif(in_array($field['type'], ['file', 'camera'])): ?>
                                                        <div class="rock-upload-input">
                                                            <div class="upload-custom-file without-image">
                                                                <input type="file" id="<?php echo e($key); ?>"
                                                                    name="custom_fields_data[<?php echo e($field['name']); ?>]"
                                                                    accept=".gif, .jpg, .png"
                                                                    onchange="showCloseButton(event)"
                                                                    <?php if($field['type'] == 'camera'): ?> capture="user" <?php endif; ?> />
                                                                <label for="<?php echo e($key); ?>">
                                                                    <span class="upload-icon">
                                                                        <svg width="48" height="48"
                                                                            viewBox="0 0 48 48" fill="none"
                                                                            xmlns="http://www.w3.org/2000/svg">
                                                                            <g filter="url(#filter0_i_2427_12057)">
                                                                                <path
                                                                                    d="M14 18L34 18C38.4183 18 42 21.5817 42 26V34C42 38.4183 38.4183 42 34 42H14C9.58172 42 6 38.4183 6 34L6 26C6 21.5817 9.58172 18 14 18Z"
                                                                                    fill="url(#paint0_linear_2427_12057)" />
                                                                            </g>
                                                                            <path
                                                                                d="M14 18.5L34 18.5C38.1421 18.5 41.5 21.8579 41.5 26V34C41.5 38.1421 38.1421 41.5 34 41.5H14C9.85787 41.5 6.5 38.1421 6.5 34L6.5 26C6.5 21.8579 9.85786 18.5 14 18.5Z"
                                                                                stroke="white" stroke-opacity="0.08" />
                                                                            <g filter="url(#filter1_i_2427_12057)">
                                                                                <path fill-rule="evenodd"
                                                                                    clip-rule="evenodd"
                                                                                    d="M16.9393 13.0607C16.3536 12.4749 16.3536 11.5251 16.9393 10.9393L22.9393 4.93934C23.5251 4.35355 24.4749 4.35355 25.0607 4.93934L31.0607 10.9393C31.6464 11.5251 31.6464 12.4749 31.0607 13.0607C30.4749 13.6464 29.5251 13.6464 28.9393 13.0607C27.6701 11.7915 25.5 12.6904 25.5 14.4853L25.5 30C25.5 30.8284 24.8284 31.5 24 31.5C23.1716 31.5 22.5 30.8284 22.5 30L22.5 14.4853C22.5 12.6904 20.3299 11.7915 19.0607 13.0607C18.4749 13.6464 17.5251 13.6464 16.9393 13.0607Z"
                                                                                    fill="url(#paint1_linear_2427_12057)" />
                                                                            </g>
                                                                            <path
                                                                                d="M17.2929 12.7071C16.9024 12.3166 16.9024 11.6834 17.2929 11.2929L23.2929 5.29289C23.6834 4.90237 24.3166 4.90237 24.7071 5.29289L30.7071 11.2929C31.0976 11.6834 31.0976 12.3166 30.7071 12.7071C30.3166 13.0976 29.6834 13.0976 29.2929 12.7071C27.7087 11.1229 25 12.2449 25 14.4853L25 30C25 30.5523 24.5523 31 24 31C23.4477 31 23 30.5523 23 30L23 14.4853C23 12.2449 20.2913 11.1229 18.7071 12.7071C18.3166 13.0976 17.6834 13.0976 17.2929 12.7071Z"
                                                                                stroke="white" stroke-opacity="0.08" />
                                                                            <defs>
                                                                                <filter id="filter0_i_2427_12057" x="2"
                                                                                    y="18" width="40" height="28"
                                                                                    filterUnits="userSpaceOnUse"
                                                                                    color-interpolation-filters="sRGB">
                                                                                    <feFlood flood-opacity="0"
                                                                                        result="BackgroundImageFix" />
                                                                                    <feBlend mode="normal"
                                                                                        in="SourceGraphic"
                                                                                        in2="BackgroundImageFix"
                                                                                        result="shape" />
                                                                                    <feColorMatrix in="SourceAlpha"
                                                                                        type="matrix"
                                                                                        values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                                        result="hardAlpha" />
                                                                                    <feOffset dx="-4"
                                                                                        dy="4" />
                                                                                    <feGaussianBlur stdDeviation="5" />
                                                                                    <feComposite in2="hardAlpha"
                                                                                        operator="arithmetic"
                                                                                        k2="-1" k3="1" />
                                                                                    <feColorMatrix type="matrix"
                                                                                        values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                                                                    <feBlend mode="normal" in2="shape"
                                                                                        result="effect1_innerShadow_2427_12057" />
                                                                                </filter>
                                                                                <filter id="filter1_i_2427_12057" x="12.5"
                                                                                    y="4.5" width="19" height="31"
                                                                                    filterUnits="userSpaceOnUse"
                                                                                    color-interpolation-filters="sRGB">
                                                                                    <feFlood flood-opacity="0"
                                                                                        result="BackgroundImageFix" />
                                                                                    <feBlend mode="normal"
                                                                                        in="SourceGraphic"
                                                                                        in2="BackgroundImageFix"
                                                                                        result="shape" />
                                                                                    <feColorMatrix in="SourceAlpha"
                                                                                        type="matrix"
                                                                                        values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                                        result="hardAlpha" />
                                                                                    <feOffset dx="-4"
                                                                                        dy="4" />
                                                                                    <feGaussianBlur stdDeviation="5" />
                                                                                    <feComposite in2="hardAlpha"
                                                                                        operator="arithmetic"
                                                                                        k2="-1" k3="1" />
                                                                                    <feColorMatrix type="matrix"
                                                                                        values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                                                                    <feBlend mode="normal" in2="shape"
                                                                                        result="effect1_innerShadow_2427_12057" />
                                                                                </filter>
                                                                                <linearGradient
                                                                                    id="paint0_linear_2427_12057"
                                                                                    x1="6" y1="18"
                                                                                    x2="28.1538" y2="51.2308"
                                                                                    gradientUnits="userSpaceOnUse">
                                                                                    <stop stop-color="#FDD819" />
                                                                                    <stop offset="1"
                                                                                        stop-color="#F81717" />
                                                                                </linearGradient>
                                                                                <linearGradient
                                                                                    id="paint1_linear_2427_12057"
                                                                                    x1="16.5" y1="31.5"
                                                                                    x2="39.4245" y2="18.7641"
                                                                                    gradientUnits="userSpaceOnUse">
                                                                                    <stop stop-color="#FDD819" />
                                                                                    <stop offset="1"
                                                                                        stop-color="#F81717" />
                                                                                </linearGradient>
                                                                            </defs>
                                                                        </svg>
                                                                    </span>
                                                                    <span><?php echo e(__('Select')); ?> <?php echo e($field['name']); ?></span>
                                                                </label>
                                                            </div>
                                                            <button type="button" class="upload-thumb-close"
                                                                onclick="removeUploadedFile(this)"><i
                                                                    class="fa-regular fa-xmark"></i></button>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="input-field">
                                                            <input type="text"
                                                                name="custom_fields_data[<?php echo e($field['name']); ?>]"
                                                                class="form-control"
                                                                <?php if($field['validation'] == 'required'): ?> required <?php endif; ?>>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>

                                    <div class="col-lg-6">
                                        <div class="td-form-group has-right-icon">
                                            <label class="input-label"><?php echo e(__('Password')); ?> <span>*</span></label>
                                            <div class="input-field">
                                                <input type="password" name="password"
                                                    class="form-control password-input"
                                                    placeholder="<?php echo e(__('Password')); ?>" required>
                                                <span class="input-icon eyeicon"><i class="icon-eye-slash"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="td-form-group has-right-icon">
                                            <label class="input-label"><?php echo e(__('Confirm Password')); ?> <span>*</span></label>
                                            <div class="input-field">
                                                <input type="password" name="password_confirmation"
                                                    class="form-control password-input"
                                                    placeholder="<?php echo e(__('Confirm Password')); ?>" required>
                                                <span class="input-icon eyeicon"><i class="icon-eye-slash"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <?php if($googleReCaptcha): ?>
                                            <div class="g-recaptcha mb-3" id="feedback-recaptcha"
                                                data-sitekey="<?php echo e(json_decode($googleReCaptcha->data, true)['google_recaptcha_key']); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="auth-login-option">
                                    <div class="animate-custom">
                                        <input class="inp-cbx" name="i_agree" id="auth_remind" type="checkbox">
                                        <label class="cbx" for="auth_remind">
                                            <span>
                                                <svg width="12px" height="9px" viewbox="0 0 12 9">
                                                    <polyline points="1 5 4 8 11 1"></polyline>
                                                </svg>
                                            </span>
                                            <span><?php echo e(__('I agree with')); ?> <a class="td-underline-btn"
                                                    href="<?php echo e(url('/privacy-policy')); ?>"> <?php echo e(__('Privacy & Policy')); ?></a> <?php echo e(__('and')); ?>

                                                <a class="td-underline-btn"
                                                    href="<?php echo e(url('/terms-and-conditions')); ?>"><?php echo e(__('Terms & Condition')); ?></a>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="auth-from-btn-wrap">
                                    <button class="td-btn gradient-btn radius-8 w-100" type="submit">
                                        <span class="btn-icon"><svg width="25" height="24" viewBox="0 0 25 24"
                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M9.607 5.448C10.205 3.698 12.623 3.645 13.332 5.289L13.392 5.449L14.199 7.809C14.5732 8.90406 15.4033 9.7834 16.475 10.22L16.692 10.301L19.052 11.107C20.802 11.705 20.855 14.123 19.212 14.832L19.052 14.892L16.692 15.699C15.5966 16.0729 14.7168 16.9031 14.28 17.975L14.199 18.191L13.393 20.552C12.795 22.302 10.377 22.355 9.669 20.712L9.607 20.552L8.801 18.192C8.42706 17.0966 7.59692 16.2168 6.525 15.78L6.309 15.699L3.949 14.893C2.198 14.295 2.145 11.877 3.789 11.169L3.949 11.107L6.309 10.301C7.40406 9.92681 8.2834 9.09671 8.72 8.025L8.801 7.809M11.5 6.094L10.694 8.454C10.124 10.1245 8.84742 11.4592 7.204 12.103L6.954 12.194L4.594 13L6.954 13.806C8.62445 14.376 9.9592 15.6526 10.603 17.296L10.694 17.546L11.5 19.906L12.306 17.546C12.876 15.8755 14.1526 14.5408 15.796 13.897L16.046 13.807L18.406 13L16.046 12.194C14.3755 11.624 13.0408 10.3474 12.397 8.704L12.307 8.454M19.5 2C19.8817 2 20.2301 2.21726 20.398 2.56L20.446 2.677L20.796 3.703L21.823 4.053C22.2064 4.18326 22.4734 4.5319 22.4993 4.93602C22.5251 5.34014 22.3047 5.71995 21.941 5.898L21.823 5.946L20.797 6.296L20.447 7.323C20.3165 7.70631 19.9677 7.9731 19.5636 7.99872C19.1595 8.02435 18.7799 7.80376 18.602 7.44L18.554 7.323L18.204 6.297L17.177 5.947C16.7936 5.81674 16.5266 5.4681 16.5007 5.06398C16.4749 4.65986 16.6953 4.28005 17.059 4.102L17.177 4.054L18.203 3.704L18.553 2.677C18.6912 2.27192 19.072 1.99974 19.5 2Z"
                                                    fill="white" />
                                            </svg>
                                        </span>
                                        <span class="btn-text"><?php echo e(__('Create account')); ?></span>
                                    </button>
                                </div>
                                <div class="auth-account text-center mt-10">
                                    <p class="description"><?php echo e(__('Already have an account?')); ?> <a
                                            class="td-underline-btn" href="<?php echo e(route('login')); ?>">
                                            <?php echo e(__('Sign in')); ?></a></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6">
                    <div class="auth-banner-wrapper has-left"
                        data-background="<?php echo e(asset('frontend/theme_base/coin_orbit/images/bg/auth-bg.png')); ?>">
                        <div class="auth-banner-content-box">
                            <div class="auth-logo">
                                <a href="<?php echo e(route('home')); ?>">
                                    <img src="<?php echo e(asset(setting('site_logo', 'global'))); ?>" alt="logo">
                                </a>
                            </div>
                            <div class="auth-banner-contents">
                                <h1 class="title"><?php echo e($data['title']); ?></h1>
                                <p class="description"><?php echo e($data['bottom_text']); ?></p>
                                <a href="<?php echo e(route('login')); ?>" class="td-btn gradient-btn radius-8" type="submit">
                                    <span class="btn-icon"><svg width="25" height="24" viewBox="0 0 25 24"
                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M9.607 5.448C10.205 3.698 12.623 3.645 13.332 5.289L13.392 5.449L14.199 7.809C14.5732 8.90406 15.4033 9.7834 16.475 10.22L16.692 10.301L19.052 11.107C20.802 11.705 20.855 14.123 19.212 14.832L19.052 14.892L16.692 15.699C15.5966 16.0729 14.7168 16.9031 14.28 17.975L14.199 18.191L13.393 20.552C12.795 22.302 10.377 22.355 9.669 20.712L9.607 20.552L8.801 18.192C8.42706 17.0966 7.59692 16.2168 6.525 15.78L6.309 15.699L3.949 14.893C2.198 14.295 2.145 11.877 3.789 11.169L3.949 11.107L6.309 10.301C7.40406 9.92681 8.2834 9.09671 8.72 8.025L8.801 7.809M11.5 6.094L10.694 8.454C10.124 10.1245 8.84742 11.4592 7.204 12.103L6.954 12.194L4.594 13L6.954 13.806C8.62445 14.376 9.9592 15.6526 10.603 17.296L10.694 17.546L11.5 19.906L12.306 17.546C12.876 15.8755 14.1526 14.5408 15.796 13.897L16.046 13.807L18.406 13L16.046 12.194C14.3755 11.624 13.0408 10.3474 12.397 8.704L12.307 8.454M19.5 2C19.8817 2 20.2301 2.21726 20.398 2.56L20.446 2.677L20.796 3.703L21.823 4.053C22.2064 4.18326 22.4734 4.5319 22.4993 4.93602C22.5251 5.34014 22.3047 5.71995 21.941 5.898L21.823 5.946L20.797 6.296L20.447 7.323C20.3165 7.70631 19.9677 7.9731 19.5636 7.99872C19.1595 8.02435 18.7799 7.80376 18.602 7.44L18.554 7.323L18.204 6.297L17.177 5.947C16.7936 5.81674 16.5266 5.4681 16.5007 5.06398C16.4749 4.65986 16.6953 4.28005 17.059 4.102L17.177 4.054L18.203 3.704L18.553 2.677C18.6912 2.27192 19.072 1.99974 19.5 2Z"
                                                fill="white" />
                                        </svg>
                                    </span>
                                    <span class="btn-text"><?php echo e(__('Sign In')); ?></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Authentication section end -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php if($googleReCaptcha): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
    <script>
        function showCloseButton(event) {
            const button = event.target.parentElement.nextElementSibling;
            button.style.display = 'block';
        }
        
        $('#countrySelect').on('change', function(e) {
            "use strict";
            e.preventDefault();
            var country = $(this).val();
            $('#dial-code').html(country.split(":")[1])
        })
    </script>


    <script>
        $(document).ready(function() {
            $('.eyeicon').on('click', function() {
                let passwordInput = $(this).siblings('.password-input');
                let icon = $(this).find('i');

                if (passwordInput.attr('type') === 'password') {
                    passwordInput.attr('type', 'text');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                } else {
                    passwordInput.attr('type', 'password');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/coin_orbit/auth/register.blade.php ENDPATH**/ ?>