
<?php $__env->startSection('title'); ?>
<?php echo e(__('Forgot password')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<section class="rock-auth-section fix">
    <div class="container">
        <div class="rock-auth-wrapper">
            <div class="rock-auth-main">
                <div class="rock-auth-logo">
                    <a href="<?php echo e(route('home')); ?>">
                        <img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="logo">
                    </a>
                </div>
                <div class="rock-auth-main-inner">
                    <div class="rock-auth-from">
                        <div class="rock-auth-content">
                            <h3 class="title"><?php echo e($data['title']); ?></h3>
                            <p class="description"><?php echo e($data['bottom_text']); ?></p>
                        </div>
                        <?php if($errors->any()): ?>
                        <div class="alert alert-warning alert-dismissible fade show" role="alert">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <strong><?php echo e($error); ?></strong>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php endif; ?>

                        <?php if(session('status')): ?>
                        <div class="alert alert-warning alert-dismissible fade show" role="alert">
                            <strong><?php echo e(session('status')); ?></strong>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php endif; ?>
                        <form action="<?php echo e(route('password.email')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row justify-content-center">
                                <div class="col-xxl-6">
                                    <div class="rock-single-input">
                                        <label class="rock-input-label" for="email"><?php echo e(__('Email Address')); ?></label>
                                        <div class="input-field">
                                            <input type="email" name="email" required value="<?php echo e(old('email')); ?>">
                                        </div>
                                    </div>
                                    <div class="rock-auth-btn mt-30 d-flex justify-content-center">
                                        <button class="site-btn gradient-btn"
                                            type="submit"><?php echo e(__('Email Password Reset Link')); ?></button>
                                    </div>
                                    <div class="rock-auth-bottm">
                                        <p class="description">
                                            <?php echo e(__("Already have an account?")); ?>

                                            <a href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="rock-auth-shapes">
                <div class="shape-one">
                    <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/rock-shapes/auth/auth-01.png')); ?>"
                        alt="auth shape">
                </div>
                <div class="shape-two">
                    <img src="<?php echo e(asset('frontend/theme_base/hardrock/images/rock-shapes/auth/auth-02.png')); ?>"
                        alt="auth shape">
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/investify/auth/forgot-password.blade.php ENDPATH**/ ?>