<?php
    $landingContent = \App\Models\LandingPage::where('code','newsletter')->where('locale',app()->getLocale())->first();
    $data = $landingContent ? json_decode($landingContent->data, true) : [];
?>

<section class="newsletter-section section-space">
       <div class="container">
           <div class="newsletter-main" data-background="<?php echo e(asset('frontend/theme_base/coinefy/images/bg/newsletter-bg.png')); ?>">
               <div class="row gy-30 align-items-center">
                   <div class="col-xxl-6 col-xl-6 col-lg-6">
                       <div class="newsletter-content">
                           <div class="section-title-wrapper mb-30">
                               <h2 class="section-title"><?php echo e($data['newsletter_title'] ?? ' Newsletter'); ?></h2>
                           </div>
                           <div class="newsletter-form">
                               <form action="<?php echo e(route('subscriber')); ?>" method="POST">
                                   <?php echo csrf_field(); ?>
                                   <div class="input-field-inner">
                                       <div class="input-field">
                                           <input type="email" name="email" placeholder="Email Address" required>
                                       </div>
                                       <button class="shape-shifter-btn primary-btn">
                                           <span class="btn-hover-slide">
                                               <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path opacity="0.4" d="M17.5291 8.27C17.4591 8.26 17.3891 8.26 17.3191 8.27C15.7691 8.22 14.5391 6.95 14.5391 5.39C14.5391 3.8 15.8291 2.5 17.4291 2.5C19.0191 2.5 20.3191 3.79 20.3191 5.39C20.3091 6.95 19.0791 8.22 17.5291 8.27Z" fill="white" />
                                                   <path opacity="0.4" d="M20.7916 15.2004C19.6716 15.9504 18.1016 16.2304 16.6516 16.0404C17.0316 15.2204 17.2316 14.3104 17.2416 13.3504C17.2416 12.3504 17.0216 11.4004 16.6016 10.5704C18.0816 10.3704 19.6516 10.6504 20.7816 11.4004C22.3616 12.4404 22.3616 14.1504 20.7916 15.2004Z" fill="white" />
                                                   <path opacity="0.4" d="M6.43843 8.27C6.50843 8.26 6.57844 8.26 6.64844 8.27C8.19844 8.22 9.42844 6.95 9.42844 5.39C9.42844 3.8 8.13844 2.5 6.53844 2.5C4.94844 2.5 3.64844 3.79 3.64844 5.39C3.65844 6.95 4.88843 8.22 6.43843 8.27Z" fill="white" />
                                                   <path opacity="0.4" d="M6.54719 13.3506C6.54719 14.3206 6.75719 15.2406 7.13719 16.0706C5.72719 16.2206 4.25719 15.9206 3.17719 15.2106C1.59719 14.1606 1.59719 12.4506 3.17719 11.4006C4.24719 10.6806 5.75719 10.3906 7.17719 10.5506C6.76719 11.3906 6.54719 12.3406 6.54719 13.3506Z" fill="white" />
                                                   <path d="M12.1169 16.37C12.0369 16.36 11.9469 16.36 11.8569 16.37C10.0169 16.31 8.54688 14.8 8.54688 12.94C8.54688 11.04 10.0769 9.5 11.9869 9.5C13.8869 9.5 15.4269 11.04 15.4269 12.94C15.4269 14.8 13.9669 16.31 12.1169 16.37Z" fill="white" />
                                                   <path d="M8.86687 18.4406C7.35687 19.4506 7.35687 21.1106 8.86687 22.1106C10.5869 23.2606 13.4069 23.2606 15.1269 22.1106C16.6369 21.1006 16.6369 19.4406 15.1269 18.4406C13.4169 17.2906 10.5969 17.2906 8.86687 18.4406Z" fill="white" />
                                               </svg>
                                               <?php echo e(__('Subscribe')); ?>

                                           </span>
                                       </button>
                                   </div>
                               </form>
                           </div>
                       </div>
                   </div>
                   <div class="col-xxl-6 col-xl-6 col-lg-6">
                       <div class="clients-coin-wrapper">
                           <div class="group-coins">
                               <div class="coin-one">
                                   <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/clients/clients-coin-01.png')); ?>" alt="clients coin">
                               </div>
                               <div class="coin-two">
                                   <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/clients/clients-coin-02.png')); ?>" alt="clients coin">
                               </div>
                               <div class="coin-three">
                                   <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/clients/clients-coin-03.png')); ?>" alt="clients coin">
                               </div>
                               <div class="coin-four">
                                   <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/clients/clients-coin-04.png')); ?>" alt="clients coin">
                               </div>
                           </div>
                       </div>
                   </div>
               </div>
           </div>
       </div>
   </section><?php /**PATH /home/shellperdido/galaticexchange.com/app/Providers/../../resources/views/frontend/coinefy/home/include/__newsletter.blade.php ENDPATH**/ ?>