

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Customer Details')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <script src="<?php echo e(asset('global/js/jquery.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Details of') . ' ' . $user->first_name . ' ' . $user->last_name); ?></h2>
                            <a href="<?php echo e(url()->previous()); ?>" class="title-btn">
                                <i icon-name="corner-down-left"></i><?php echo e(__('Back')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-xxl-3 col-xl-6 col-lg-8 col-md-6 col-sm-12">
                    <div class="profile-card">
                        <div class="top">
                            <div class="avatar">
                                <?php if($user->avatar): ?>
                                    <img class="avatar-image" src="<?php echo e(asset($user->avatar)); ?>" alt="<?php echo e($user->first_name); ?>" />
                                <?php else: ?>
                                    <span class="avatar-text"><?php echo e($user->first_name[0] . $user->last_name[0]); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="title-des">
                                <h4><?php echo e($user->first_name . ' ' . $user->last_name); ?></h4>
                                <p><?php echo e(ucwords($user->city)); ?><?php if($user->city): ?> , <?php endif; ?> <?php echo e($user->country); ?></p>
                            </div>
                            <div>
                                <p><?php echo e(__('Last Login:') . ' ' . $login_activities->created_at); ?></p>
                                <p><?php echo e(__('Browser:') . ' ' . $login_activities->browser); ?></p>
                            </div>
                            <div class="btns">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-mail-send')): ?>
                                    <span type="button" data-bs-toggle="modal" data-bs-target="#sendEmail">
                                        <a href="javascript:void(0);" class="site-btn-round blue-btn" data-bs-toggle="tooltip" title="<?php echo e(__('Send Email')); ?>">
                                            <i icon-name="mail"></i>
                                        </a>
                                    </span>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-login')): ?>
                                    <a href="<?php echo e(route('admin.user.login',$user->id)); ?>" target="_blank" class="site-btn-round red-btn" data-bs-toggle="tooltip" title="<?php echo e(__('Login As User')); ?>">
                                        <i icon-name="user-plus"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-balance-add-or-subtract')): ?>
                                    <span data-bs-toggle="modal" data-bs-target="#addSubBal">
                                        <a href="javascript:void(0);" class="site-btn-round primary-btn" data-bs-toggle="tooltip" title="<?php echo e(__('Fund Add or Subtract')); ?>">
                                            <i icon-name="wallet"></i>
                                        </a>
                                    </span>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-balance-add-or-subtract')): ?>
                                    <span data-bs-toggle="modal" data-bs-target="#sendNotification">
                                    <a href="javascript:void(0);" class="site-btn-round primary-btn" data-bs-toggle="tooltip" title="<?php echo e(__('Send Notification')); ?>">
                                         <i icon-name="bell-ring"></i>
                                    </a>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="site-card">
                            <div class="site-card-body">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="admin-user-balance-card">
                                            <div class="wallet-name">
                                                <div class="name"><?php echo e(__('Main Wallet')); ?></div>
                                                <div class="chip-icon">
                                                    <img class="chip" src="<?php echo e(asset('backend/materials/chip.png')); ?>" alt="" />
                                                </div>
                                            </div>
                                            <div class="wallet-info">
                                                <div class="wallet-id"><?php echo e(setting('site_currency', 'global')); ?></div>
                                                <div class="balance"><?php echo e(setting('currency_symbol', 'global') . $user->balance); ?></div>
                                            </div>
                                        </div>
                                        <div class="admin-user-balance-card">
                                            <div class="wallet-name">
                                                <div class="name"><?php echo e(__('Profit Wallet')); ?></div>
                                                <div class="chip-icon">
                                                    <img class="chip" src="<?php echo e(asset('backend/materials/chip.png')); ?>" alt="" />
                                                </div>
                                            </div>
                                            <div class="wallet-info">
                                                <div class="wallet-id"><?php echo e(setting('site_currency', 'global')); ?></div>
                                                <div class="balance"><?php echo e(setting('currency_symbol', 'global') . $user->profit_balance); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- User Status Update -->
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('all-type-status')): ?>
                        <?php echo $__env->make('backend.user.include.__status_update', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!-- User Status Update End-->
                    </div>
                </div>

                <div class="col-xxl-9 col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <div class="site-tab-bars">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <!-- Informations Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['customer-basic-manage', 'customer-change-password'])): ?>
                                <li class="nav-item" role="presentation">
                                    <a href="<?php echo e(route('admin.user.edit', ['user' => $user->id, 'tab' => 'informations'])); ?>"
                                       class="nav-link <?php echo e(request()->get('tab') === 'informations' || is_null(request()->get('tab')) ? 'active' : ''); ?>"
                                       id="pills-informations-tab"
                                       type="button"
                                       role="tab"
                                       aria-controls="pills-informations"
                                       aria-selected="<?php echo e(request()->get('tab') === 'informations' || is_null(request()->get('tab')) ? 'true' : 'false'); ?>">
                                        <i icon-name="user"></i><?php echo e(__('Informations')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                        <!-- Investment Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('investment-list')): ?>
                                <li class="nav-item" role="presentation">
                                    <a href="<?php echo e(route('admin.user.edit',['user'=>$user->id,'tab'=>'investments'])); ?>"
                                       class="nav-link <?php echo e(request()->get('tab') === 'investments' ? 'active' : ''); ?>"
                                       id="pills-transfer-tab"
                                       type="button"
                                       role="tab"
                                       aria-controls="pills-transfer"
                                       aria-selected="<?php echo e(request()->get('tab') === 'investments' ? 'true' : 'false'); ?>">
                                        <i icon-name="anchor"></i><?php echo e(__('Investments')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                        <!-- Earning Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('profit-list')): ?>
                                <li class="nav-item" role="presentation">
                                    <a href="<?php echo e(route('admin.user.edit',['user'=>$user->id,'tab'=>'earnings'])); ?>"
                                       class="nav-link <?php echo e(request()->get('tab') === 'earnings' ? 'active' : ''); ?>"
                                       id="pills-deposit-tab"
                                       type="button"
                                       role="tab"
                                       aria-controls="pills-deposit"
                                       aria-selected="<?php echo e(request()->get('tab') === 'earnings' ? 'true' : 'false'); ?>">
                                        <i icon-name="credit-card"></i><?php echo e(__('Earnings')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                        <!-- Transaction Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transaction-list')): ?>
                                <li class="nav-item" role="presentation">
                                    <a href="<?php echo e(route('admin.user.edit',['user'=>$user->id,'tab'=>'transactions'])); ?>"
                                       class="nav-link <?php echo e(request()->get('tab') === 'transactions' ? 'active' : ''); ?>"
                                       id="pills-transactions-tab"
                                       type="button"
                                       role="tab"
                                       aria-controls="pills-transactions"
                                       aria-selected="<?php echo e(request()->get('tab') === 'transactions' ? 'true' : 'false'); ?>">
                                        <i icon-name="cast"></i><?php echo e(__('Transactions')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                        <!-- Referral Tree Tab -->
                            <?php if(setting('site_referral', 'global') == 'level'): ?>
                                <li class="nav-item" role="presentation">
                                    <a href="<?php echo e(route('admin.user.edit',['user'=>$user->id,'tab'=>'referral_tree'])); ?>"
                                       class="nav-link <?php echo e(request()->get('tab') === 'referral_tree' ? 'active' : ''); ?>"
                                       id="pills-tree-tab"
                                       type="button"
                                       role="tab"
                                       aria-controls="pills-tree"
                                       aria-selected="<?php echo e(request()->get('tab') === 'referral_tree' ? 'true' : 'false'); ?>">
                                        <i icon-name="network"></i><?php echo e(__('Referral Tree')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                        <!-- Ticket Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['support-ticket-list', 'support-ticket-action'])): ?>
                                <li class="nav-item" role="presentation">
                                    <a href="<?php echo e(route('admin.user.edit',['user'=>$user->id,'tab'=>'tickets'])); ?>"
                                       class="nav-link <?php echo e(request()->get('tab') === 'tickets' ? 'active' : ''); ?>"
                                       id="pills-ticket-tab"
                                       type="button"
                                       role="tab"
                                       aria-controls="pills-ticket"
                                       aria-selected="<?php echo e(request()->get('tab') === 'tickets' ? 'true' : 'false'); ?>">
                                        <i icon-name="wrench"></i><?php echo e(__('Ticket')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                    <div class="site-tab-content">
                        <div class="tab-content" id="pills-tabContent">
                            <!-- Informations Tab Content -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['customer-basic-manage', 'customer-change-password'])): ?>
                                <div class="tab-pane fade <?php echo e(request()->get('tab') === 'informations' || is_null(request()->get('tab')) ? 'show active' : ''); ?>" id="pills-informations" role="tabpanel">
                                    <?php echo $__env->make('backend.user.include.__basic_info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endif; ?>

                        <!-- Investments Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('investment-list')): ?>
                                <div class="tab-pane fade <?php echo e(request()->get('tab') === 'investments' ? 'show active' : ''); ?>" id="pills-investments" role="tabpanel">
                                    <?php echo $__env->make('backend.user.include.__investments', ['data' => $investmentData], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endif; ?>

                        <!-- Earnings Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('profit-list')): ?>
                                <div class="tab-pane fade <?php echo e(request()->get('tab') === 'earnings' ? 'show active' : ''); ?>" id="pills-earnings" role="tabpanel">
                                    <?php echo $__env->make('backend.user.include.__earnings', ['data' => $earningData], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endif; ?>

                        <!-- Transactions Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transaction-list')): ?>
                                <div class="tab-pane fade <?php echo e(request()->get('tab') === 'transactions' ? 'show active' : ''); ?>" id="pills-transactions" role="tabpanel">
                                    <?php echo $__env->make('backend.user.include.__transactions', ['data' => $transactionData], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endif; ?>

                        <!-- Referral Tree Tab -->
                            <?php if(setting('site_referral', 'global') == 'level'): ?>
                                <div class="tab-pane fade <?php echo e(request()->get('tab') === 'referral_tree' ? 'show active' : ''); ?>" id="pills-referral_tree" role="tabpanel">
                                    <?php echo $__env->make('backend.user.include.__referral_tree', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endif; ?>

                        <!-- Ticket Tab -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['support-ticket-list', 'support-ticket-action'])): ?>
                                <div class="tab-pane fade <?php echo e(request()->get('tab') === 'tickets' ? 'show active' : ''); ?>" id="pills-tickets" role="tabpanel">
                                    <?php echo $__env->make('backend.user.include.__ticket',['tickets', $tickets], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Send Email -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-mail-send')): ?>
        <?php echo $__env->make('backend.user.include.__mail_send',['name' => $user->first_name.' '.$user->last_name, 'id' => $user->id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- Modal for Add or Subtract Balance -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-balance-add-or-subtract')): ?>
        <?php echo $__env->make('backend.user.include.__balance', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <?php echo $__env->make('backend.user.include.__notification_send',['name' => $user->first_name.' '.$user->last_name, 'id' => $user->id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shellperdido/galaticexchange.com/resources/views/backend/user/edit.blade.php ENDPATH**/ ?>