@php
$landingContent =\App\Models\LandingContent::where('type','counter')->where('locale',app()->getLocale())->get();
@endphp

<!-- Counter section start -->
<section class="counter-section section-space-bottom p-relative z-index:15">
    <div class="container">
        <div class="counter-main-wrapper">
            <div class="counter-item-grid">
                @foreach($landingContent as $content)
                <div class="counter-item">
                    <div class="counter-content">
                        <div class="icon">
                            <span>
                                <img src="{{ asset($content->icon) }}" alt="counter">
                            </span>
                        </div>
                        <p class="description">{{ $content->title }}</p>
                        <h3 class="title">
                            @php
                                $description = $content->description;
                                if ($description >= 1000000000) {
                                    $formattedDescription = round($description / 1000000000, 1) . 'B+';
                                } elseif ($description >= 1000000) {
                                    $formattedDescription = round($description / 1000000, 1) . 'M+';
                                } elseif ($description >= 1000) {
                                    $formattedDescription = round($description / 1000, 1) . 'K+';
                                } else {
                                    $formattedDescription = number_format($description);
                                }
                            @endphp
                            <span class="">{{ $formattedDescription }}</span>
                        </h3>
                    </div>
                </div>
                @endforeach
            </div>
            <div class="coin-one">
                <img src="{{asset('frontend/theme_base/coinefy/images/counter/counter-coin-01.png')}}" alt="counter coin">
            </div>
            <div class="coin-two">
                <img src="{{asset('frontend/theme_base/coinefy/images/counter/counter-coin-02.png')}}" alt="counter coin">
            </div>
            <div class="coin-three">
                <img src="{{asset('frontend/theme_base/coinefy/images/counter/counter-coin-03.png')}}" alt="counter coin">
            </div>
            <div class="coin-four">
                <img src="{{asset('frontend/theme_base/coinefy/images/counter/counter-coin-04.png')}}" alt="counter coin">
            </div>
            <div class="counter-glow">
                <img src="{{asset('frontend/theme_base/coinefy/images/counter/counter-glow.png')}}" alt="">
            </div>
        </div>
    </div>
</section>
<!-- Counter section end -->