@extends('frontend::layouts.auth')
@section('title')
{{ __('Forgot password') }}
@endsection
@section('content')

<div class="forgot-password-area">
    <div class="auth-inner">
        <div class="auth-wrapper">
            <div class="auth-from-inner">
                <div class="auth-from-top-content">
                    <div class="auth-logo">
                        <a href="{{ route('home')}}"><img src="{{ asset(setting('site_logo','global')) }}" alt="" /></a>
                    </div>
                    <h3 class="title">{{ $data['title'] }}</h3>
                    <p class="description">{{ $data['bottom_text'] }}</p>
                </div>
                @if ($errors->any())
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    @foreach($errors->all() as $error)
                    <strong>{{$error}}</strong>
                    @endforeach
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif

                @if(session('status'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <strong>{{ session('status') }}</strong>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
                <div class="auth-from-box">
                    <form id="login-form" method="POST" action="{{ route('password.email') }}">
                        @csrf
                        <div class="coinefy-single-input has-right-icon mb-25">
                            <div class="input-field">
                                <input name="email" type="text" class="box-input" placeholder="Enter email" value="{{ old('email') }}" required>
                                <span class="input-icon"><i class="icon-sms"></i></span>
                            </div>
                            <p class="feedback-invalid">This field is required</p>
                        </div>
                        <div class="auth-from-btn-wrap">
                            <button class="site-btn primary-btn w-100" type="submit">{{ __('Email Password Reset Link') }}</button>
                        </div>
                    </form>
                </div>
                <div class="auth-from-bottom-content">
                    <div class="auth-privacy-policy">
                        <p class="description">By clicking Sign in, you agree to our <a class="link" href="{{url('/terms-and-conditions')}}"> Terms & Condition</a> <span>and</span> <a class="link" href="{{url('/privacy-policy')}}"> Privacy Policy</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection