@extends('frontend::pages.index')
@section('title')
{{ $blog->title }}
@endsection
@section('page-content')

   <!-- Postbox details section start -->
   <section class="coinefy-postbox-details-area position-relative inner-pages_space-top section_space-bottom">
      <div class="container">
         <div class="row">
            <div class="col-xxl-12">
               <div class="postbox-big-thumb-box text-center mb-50">
                  <h2 class="mb-45">{{ $blog->title }}</h2>
                  <div class="postbox-big-thumb">
                     <img src="{{ asset($blog->cover) }}" alt="Postbox Big">
                  </div>
               </div>
            </div>
         </div>
         <div class="row g-40">
            <div class="col-xxl-8 col-xl-7 col-lg-7">
               <div class="postbox-contents">
                  {!! $blog->details !!}
               </div>
            </div>
            <div class="col-xxl-4 col-xl-5 col-lg-5">
               <div class="sidebar-main-wrapper">
                  <div class="sidebar-wrapper">
                     <div class="sidebar-widget">
                        <h3 class="sidebar-widget-title">{{ $data['sidebar_widget_title'] }}</h3>
                        <div class="sidebar-widget-content">
                           <div class="sidebar-post">
                              @foreach($blogs as $id => $recent)
                              <a href="{{ route('blog-details',$recent->id) }}" class="rc-post-item">
                                 <div class="rc-post-meta">
                                    <div class="article">
                                       {{ __('Article') }}
                                    </div>
                                    <div class="meta-info">
                                       <span>{{ $recent->created_at }}</span>
                                    </div>
                                 </div>
                                 <div class="rc-post-content">
                                    <h5 class="rc-post-title">
                                       {{ $recent->title }}
                                    </h5>
                                    <p class="description">{{ Str::limit(strip_tags($recent->details),35)   }}</p>
                                 </div>
                              </a>
                              @endforeach

                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </section>
   <!-- Postbox details section end -->

   <!-- CTA section end -->
   <?php
   $landata = \App\Models\LandingPage::where('code', 'cta')
       ->where('locale', app()->getLocale())
       ->first();

   $data = json_decode($landata['data'], true);
   ?>
   @include('frontend::home.include.__cta',$data)
   <!-- Cta section end -->
@endsection