@php
$gatewayList = \App\Models\Gateway::where('status',true)->pluck('logo','name')->chunk(10);
@endphp

<!-- Payment gateways section start -->
<section class="td-payment-gateways-section p-relative z-index-11 section_space-bottom">
    <div class="container">
        <div class="row section_title_space">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="section-title-wrapper">
                    <span class="section-subtitle">{{ $data['title_small'] }}</span>
                    <h2 class="section-title has_fade_anim mb-15">{{ $data['title_big'] }}</h2>
                </div>
            </div>
        </div>
        <div class="payment-gateways-grid fix">
            <div class="payment_gateways_active has_fade_anim" dir="rtl">
                <div class="swiper-container" data-space-between="24" data-slides="5">
                    <div class="swiper-wrapper">
                        @foreach ($gatewayList as $gateways)
                            @foreach ($gateways as $gateway => $logo)
                            <div class="swiper-slide">
                                <div class="payment-gateways-item">
                                    <div class="payment-gateways-thumb">
                                        <img src="{{ asset($logo) }}" alt="Payment Gateway">
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="payment_gateways_active has_fade_anim">
                <div class="swiper-container" data-space-between="24" data-slides="5">
                    <div class="swiper-wrapper">
                        @foreach ($gatewayList as $gateways)
                            @foreach ($gateways as $gateway => $logo)
                            <div class="swiper-slide">
                                <div class="payment-gateways-item">
                                    <div class="payment-gateways-thumb">
                                        <img src="{{ asset($logo) }}" alt="Payment Gateway">
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="payment-gateways-glows">
        <div class="glow-one">
            <img src="{{ asset('frontend/theme_base/coin_orbit/images/payment-gateways/gateways-glow-01.png') }}" alt="gateways">
        </div>
    </div>
</section>
<!-- Payment gateways area end -->