@php
$landingContent =\App\Models\LandingContent::where('type','faq')->where('locale',app()->getLocale())->get();
@endphp

<!-- FAQ section start -->
<section class="td-faq-section p-relative z-index-11">
    <div class="container">
        <div class="row gy-30">
            <div class="col-xxl-5 col-xl-5 col-lg-5">
                <div class="faq-contents">
                    <div class="section-title-wrapper">
                        <span class="section-subtitle">{{ $data['title_small'] }}</span>
                        <h2 class="section-title has_fade_anim mb-15">{{ $data['title_big'] }}</h2>

                    </div>
                    <div class="faq-thumb has_fade_anim" data-fade-from="bottom" data-delay="0.30">
                        <img src="{{ asset('frontend/theme_base/coin_orbit/images/faq/faq-thumb.png') }}" alt="Faq Thumb">
                    </div>
                </div>
            </div>
            <div class="col-xxl-7 col-xl-7 col-lg-7">
                <div class="faq-style-one fix">
                    <div class="accordion" id="accordionExample">
                        @foreach($landingContent as $key => $contents)
                            <div class="accordion-item {{ $key == 0 ? 'accordion-active' : '' }} has_fade_anim">
                                <h2 class="accordion-header">
                                    <button class="accordion-button {{ $key == 0 ? '' : 'collapsed' }}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $key }}" aria-expanded="{{ $key == 0 ? 'true' : 'false' }}" aria-controls="collapse{{ $key }}">
                                        <span>
                                            <img src="{{ asset('frontend/theme_base/coin_orbit/images/faq/icon-04.png') }}" alt="FAQ Icon">
                                        </span>
                                        {{ $contents['title'] }}
                                    </button>
                                </h2>
                                <div id="collapse{{ $key }}" class="accordion-collapse collapse {{ $key == 0 ? 'show' : '' }}" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p class="description">{{ $contents['description'] }}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="faq-glows">
        <div class="glow-one">
            <img src="{{ asset('frontend/theme_base/coin_orbit/images/faq/faq-glow-01.png') }}" alt="Faq Glow">
        </div>
    </div>
</section>
<!-- FAQ section end -->