@extends('frontend::layouts.auth')
@section('title')
    {{ __('Verify Email') }}
@endsection
@section('content')
    <!-- Authentication section start -->
    <section class="td-authentication-section">
        <div class="container">
            <div class="row gy-50 align-items-center">
                <div class="col-xxl-6 col-xl-6 col-lg-6">
                    <div class="auth-from-box">
                        <div class="auth-intro-content mb-30">
                            <h2 class="title">{{ __('Verify Your Email') }}</h2>
                            <p class="description">{{ __('Verify your email address by clicking on the link we just emailed to you') }}</p>
                        </div>
                        @if (session('status') == 'verification-link-sent')
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ __('A new verification link has been sent to the email address you provided during registration.') }}
                            </div>
                        @endif
                        <form  novalidate action="{{ route('verification.send') }}" method="POST">
                            @csrf
                            <div class="auth-from-btn-wrap mt-20">
                                <button class="td-btn gradient-btn radius-8 w-100" type="submit">
                              <span class="btn-icon"><svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                 <path d="M9.607 5.448C10.205 3.698 12.623 3.645 13.332 5.289L13.392 5.449L14.199 7.809C14.5732 8.90406 15.4033 9.7834 16.475 10.22L16.692 10.301L19.052 11.107C20.802 11.705 20.855 14.123 19.212 14.832L19.052 14.892L16.692 15.699C15.5966 16.0729 14.7168 16.9031 14.28 17.975L14.199 18.191L13.393 20.552C12.795 22.302 10.377 22.355 9.669 20.712L9.607 20.552L8.801 18.192C8.42706 17.0966 7.59692 16.2168 6.525 15.78L6.309 15.699L3.949 14.893C2.198 14.295 2.145 11.877 3.789 11.169L3.949 11.107L6.309 10.301C7.40406 9.92681 8.2834 9.09671 8.72 8.025L8.801 7.809M11.5 6.094L10.694 8.454C10.124 10.1245 8.84742 11.4592 7.204 12.103L6.954 12.194L4.594 13L6.954 13.806C8.62445 14.376 9.9592 15.6526 10.603 17.296L10.694 17.546L11.5 19.906L12.306 17.546C12.876 15.8755 14.1526 14.5408 15.796 13.897L16.046 13.807L18.406 13L16.046 12.194C14.3755 11.624 13.0408 10.3474 12.397 8.704L12.307 8.454M19.5 2C19.8817 2 20.2301 2.21726 20.398 2.56L20.446 2.677L20.796 3.703L21.823 4.053C22.2064 4.18326 22.4734 4.5319 22.4993 4.93602C22.5251 5.34014 22.3047 5.71995 21.941 5.898L21.823 5.946L20.797 6.296L20.447 7.323C20.3165 7.70631 19.9677 7.9731 19.5636 7.99872C19.1595 8.02435 18.7799 7.80376 18.602 7.44L18.554 7.323L18.204 6.297L17.177 5.947C16.7936 5.81674 16.5266 5.4681 16.5007 5.06398C16.4749 4.65986 16.6953 4.28005 17.059 4.102L17.177 4.054L18.203 3.704L18.553 2.677C18.6912 2.27192 19.072 1.99974 19.5 2Z" fill="white"/>
                                 </svg>
                              </span>
                                    <span class="btn-text">{{ __('Resend Verification Email') }}</span>
                                </button>
                            </div>
                        </form>

                        <form  novalidate action="{{ route('logout') }}" method="POST">
                            @csrf
                            <div class="auth-from-btn-wrap mt-20">
                                <button class="td-btn gradient-btn radius-8 w-100" type="submit">
                              <span class="btn-icon"><svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                 <path d="M9.607 5.448C10.205 3.698 12.623 3.645 13.332 5.289L13.392 5.449L14.199 7.809C14.5732 8.90406 15.4033 9.7834 16.475 10.22L16.692 10.301L19.052 11.107C20.802 11.705 20.855 14.123 19.212 14.832L19.052 14.892L16.692 15.699C15.5966 16.0729 14.7168 16.9031 14.28 17.975L14.199 18.191L13.393 20.552C12.795 22.302 10.377 22.355 9.669 20.712L9.607 20.552L8.801 18.192C8.42706 17.0966 7.59692 16.2168 6.525 15.78L6.309 15.699L3.949 14.893C2.198 14.295 2.145 11.877 3.789 11.169L3.949 11.107L6.309 10.301C7.40406 9.92681 8.2834 9.09671 8.72 8.025L8.801 7.809M11.5 6.094L10.694 8.454C10.124 10.1245 8.84742 11.4592 7.204 12.103L6.954 12.194L4.594 13L6.954 13.806C8.62445 14.376 9.9592 15.6526 10.603 17.296L10.694 17.546L11.5 19.906L12.306 17.546C12.876 15.8755 14.1526 14.5408 15.796 13.897L16.046 13.807L18.406 13L16.046 12.194C14.3755 11.624 13.0408 10.3474 12.397 8.704L12.307 8.454M19.5 2C19.8817 2 20.2301 2.21726 20.398 2.56L20.446 2.677L20.796 3.703L21.823 4.053C22.2064 4.18326 22.4734 4.5319 22.4993 4.93602C22.5251 5.34014 22.3047 5.71995 21.941 5.898L21.823 5.946L20.797 6.296L20.447 7.323C20.3165 7.70631 19.9677 7.9731 19.5636 7.99872C19.1595 8.02435 18.7799 7.80376 18.602 7.44L18.554 7.323L18.204 6.297L17.177 5.947C16.7936 5.81674 16.5266 5.4681 16.5007 5.06398C16.4749 4.65986 16.6953 4.28005 17.059 4.102L17.177 4.054L18.203 3.704L18.553 2.677C18.6912 2.27192 19.072 1.99974 19.5 2Z" fill="white"/>
                                 </svg>
                              </span>
                                    <span class="btn-text">{{ __('Log Out') }}</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6 order-lg-first">
                    <div class="auth-banner-wrapper has-left" data-background="{{ asset('frontend/theme_base/coin_orbit/images/bg/auth-bg.png') }}">
                        <div class="auth-banner-content-box">
                            <div class="auth-logo">
                                <a href="{{ route('home') }}">
                                    <img src="{{ asset(setting('site_logo','global')) }}" alt="logo">
                                </a>
                            </div>
                            <div class="auth-banner-contents">
                                <h1 class="title">{{ __('Verify Your Email') }}</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Authentication section end -->
@endsection



