@extends('backend.withdraw.index')
@section('title')
    {{ __('Pending Withdraws') }}
@endsection
@section('withdraw_content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="site-table table-responsive">
                    <form action="{{ request()->url() }}" method="get">
                        <div class="table-filter d-flex justify-content-between">
                            <div class="filter d-flex">
                                <div class="search">
                                    <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                </div>
                                <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i>{{ __('Search') }}</button>
                            </div>
                        </div>
                    </form>
                    <table class="table">
                        <thead>
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('User') }}</th>
                            <th>{{ __('Transaction ID') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Charge') }}</th>
                            <th>{{ __('Gateway') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Action') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse ($pendings as $pending)

                            <tr>
                                <td>{{ $pending->created_at }}</td>
                                <td>@include('backend.transaction.include.__user', ['item' => $pending])</td>
                                <td>{{ $pending->tnx}}</td>
                                <td>@include('backend.transaction.include.__txn_amount', ['item' => $pending])</td>
                                <td>{{ $pending->charge . ' ' . setting('site_currency', 'global') }}</td>
                                <td>{{$pending->method}}</td>
                                <td>@include('backend.transaction.include.__txn_status', ['status' => $pending->status])</td>
                                <td>@include('backend.withdraw.include.__action', ['item' => $pending])</td>
                            </tr>
                        @empty
                            <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                        @endforelse
                        </tbody>
                    </table>
                    {{ $pendings->links('backend.include.__pagination') }}
                </div>
            </div>
        </div>
    </div>
    <!-- Modal for Pending Deposit Approval -->
    @can('withdraw-action')
        <div class="modal fade" id="deposit-action-modal" tabindex="-1" aria-labelledby="editPendingDepositModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-md modal-dialog-centered">
                <div class="modal-content site-table-modal">
                    <div class="modal-body popup-body">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="popup-body-text withdraw-action">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endcan
    <!-- Modal for Pending Deposit Approval -->

@endsection
@section('script')
    <script>
        (function($) {
            "use strict";

            //send mail modal form open
            $('body').on('click', '#withdrawActionBtn', function() {
 
                var id = $(this).data('id');
                var url = '{{ route("admin.withdraw.action",":id") }}';
                url = url.replace(':id', id);
                $.get(url, function(data) {
                    $('.withdraw-action').html(data)
                    imagePreview()
                })
                $('#deposit-action-modal').modal('toggle')

            });

        })(jQuery);
    </script>
@endsection