@extends('backend.layouts.app')
@section('title')
    {{ __('All Subscribers') }}
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title">{{$title}}</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="{{ request()->url() }}" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i>{{ __('Search') }}</button>
                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                            <tr>
                                <th>{{ __('Subscription Date') }}</th>
                                <th>{{ __('Email') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse ($data as $subs)
                                <tr>
                                    <td>{{$subs->created_at}}</td>
                                    <td>{{ $subs->email }}</td>
                                </tr>
                            @empty
                                <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                            @endforelse
                            </tbody>
                        </table>
                        {{ $data->links('backend.include.__pagination') }}
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection