@extends('backend.layouts.app')
@section('title')
    {{ __('Add New Schema') }}
@endsection
@section('style')
    <link rel="stylesheet" href="{{ asset('backend/css/choices.min.css') }}">
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-8">
                        <div class="title-content">
                            <h2 class="title">{{ __('Add New Schema') }}</h2>
                            <a href="{{ url()->previous() }}" class="title-btn"><i
                                        icon-name="corner-down-left"></i>{{ __('Back') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-xl-8">
                    <div class="site-card">
                        <div class="site-card-body">
                            <form action="{{route('admin.schema.store')}}" method="post" enctype="multipart/form-data"
                                  class="row">
                                @csrf
                                <div class="col-xl-12">
                                    <div class="row">
                                        <div class="col-xl-3">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Upload Icon:') }}</label>
                                                <div class="wrap-custom-file">
                                                    <input
                                                            type="file"
                                                            name="icon"
                                                            id="schema-icon"
                                                            accept=".gif, .jpg, .png"
                                                            required
                                                    />
                                                    <label for="schema-icon">
                                                        <img
                                                                class="upload-icon"
                                                                src="{{asset('global/materials/upload.svg')}}"
                                                                alt=""
                                                        />
                                                        <span>{{ __('Upload Avatar') }}</span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 schema-name">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Name:') }}</label>
                                        <input
                                                type="text"
                                                name="name"
                                                class="box-input"
                                                placeholder="Investment Plan name"
                                                required
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-6 schema-badge">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Badge:') }}</label>
                                        <input
                                                type="text"
                                                class="box-input"
                                                placeholder="Schema Badge"
                                                name="badge"
                                                required
                                        />
                                    </div>
                                </div>
                                <!-- Schema Type -->
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Type:') }}</label>
                                        <div class="switch-field same-type">
                                            <input type="radio" id="fixed-type" name="schema_type" value="fixed" />
                                            <label for="fixed-type">{{ __('Fixed') }}</label>
                                            <input type="radio" id="range-type" name="schema_type" value="range" checked />
                                            <label for="range-type">{{ __('Range') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups row">
                                        <div class="col-xl-6 schema-min-amount">
                                            <label class="box-input-label" for="">{{ __('Min Amount:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="schema_min_amount" oninput="this.value = validateDouble(this.value)" class="form-control" required />
                                                <span class="input-group-text">{{ setting('site_currency','global') }}</span>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 schema-max-amount">
                                            <label class="box-input-label" for="">{{ __('Max Amount:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="schema_max_amount" oninput="this.value = validateDouble(this.value)" class="form-control" required />
                                                <span class="input-group-text">{{ setting('site_currency','global') }}</span>
                                            </div>
                                        </div>
                                        <div class="col-xl-12 schema-fixed-amount hidden">
                                            <label class="box-input-label" for="">{{ __('Amount:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="schema_fixed_amount" oninput="this.value = validateDouble(this.value)" class="form-control" />
                                                <span class="input-group-text">{{ setting('site_currency','global') }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- ROI Type -->
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('ROI Type:') }}</label>
                                        <div class="switch-field same-type">
                                            <input type="radio" id="roi-fixed-type" name="roi_type" value="fixed" />
                                            <label for="roi-fixed-type">{{ __('Fixed') }}</label>
                                            <input type="radio" id="roi-range-type" name="roi_type" value="range" checked />
                                            <label for="roi-range-type">{{ __('Range') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups row">
                                        <div class="col-xl-6 roi-min-amount">
                                            <label class="box-input-label" for="">{{ __('Min:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="roi_min_amount" oninput="this.value = validateDouble(this.value)" class="form-control" required />
                                            </div>
                                        </div>
                                        <div class="col-xl-6 roi-max-amount">
                                            <label class="box-input-label" for="">{{ __('Max:') }}</label>
                                            <div class="position-relative">
                                                <input type="text" class="box-input"  name="roi_max_amount" oninput="this.value = validateDouble(this.value)" required />
                                                <div class="prcntcurr">
                                                    <select name="roi_interest_type_range" class="form-select" id="">
                                                        <option value="percentage">{{ __('%') }}</option>
                                                        <option value="fixed">{{ $currencySymbol }}</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-12 roi-fixed-amount">
                                            <label class="box-input-label" for="">{{ __('Fixed Interest Amount:') }}</label>
                                            <div class="position-relative">
                                                <input type="text" class="box-input"  name="roi_fixed_amount" oninput="this.value = validateDouble(this.value)" required />
                                                <div class="prcntcurr">
                                                    <select name="roi_interest_type_fixed" class="form-select" id="">
                                                        <option value="percentage">{{ __('%') }}</option>
                                                        <option value="fixed">{{ $currencySymbol }}</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Return Period:') }}</label>
                                        <select name="return_period" class="form-select" id="">
                                            @foreach($schedules as $schedule)
                                                <option value="{{$schedule->id}}">{{$schedule->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Return Type:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="return-type-period"
                                                    name="return_type"
                                                    checked=""
                                                    value="period"
                                            />
                                            <label for="return-type-period">{{ __('Period') }}</label>
                                            <input
                                                    type="radio"
                                                    id="return-type-lifetime"
                                                    name="return_type"
                                                    value="lifetime"
                                            />
                                            <label for="return-type-lifetime">{{ __('Lifetime') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 number-period">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Number of Period:') }}</label>
                                        <div class="input-group joint-input">
                                            <input
                                                    type="text"
                                                    name="number_of_period"
                                                    onkeypress="return validateNumber(event)"
                                                    class="form-control"
                                                    placeholder="Total Repeat Time"
                                                    required
                                            />
                                            <span class="input-group-text">{{ __('Times') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Profit Return Holiday (If you put any day here, user will never get the profit on that day):') }}</label>
                                        <select id="choices-multiple-remove-button" name="off_days[]" placeholder="Manage Days" multiple>
                                            @foreach($holidays as $item)
                                                <option value="{{ $item->date }}">
                                                    {{ $item->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="row">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Capital Back:') }}</label>
                                                <div class="switch-field same-type">
                                                    <input
                                                            type="radio"
                                                            id="radio-seven"
                                                            name="capital_back"
                                                            checked=""
                                                            value="1"
                                                    />
                                                    <label for="radio-seven">{{ __('Yes') }}</label>
                                                    <input
                                                            type="radio"
                                                            id="radio-eight"
                                                            name="capital_back"
                                                            value="0"
                                                    />
                                                    <label for="radio-eight">{{ __('No') }}</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Featured:') }}</label>
                                                <div class="switch-field same-type">
                                                    <input
                                                            type="radio"
                                                            id="featured-yes"
                                                            name="featured"
                                                            checked=""
                                                            value="1"
                                                    />
                                                    <label for="featured-yes">{{ __('Yes') }}</label>
                                                    <input
                                                            type="radio"
                                                            id="featured-no"
                                                            name="featured"
                                                            value="0"
                                                    />
                                                    <label for="featured-no">{{ __('No') }}</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-6  schema-cancel">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Cancel:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="schema-cancel-yes"
                                                    name="schema_cancel"
                                                    value="1"
                                            />
                                            <label for="schema-cancel-yes">{{ __('Yes') }}</label>
                                            <input
                                                    type="radio"
                                                    id="schema-cancel-no"
                                                    name="schema_cancel"
                                                    checked=""
                                                    value="0"
                                            />
                                            <label for="schema-cancel-no">{{ __('No') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6  cancel-expiry hidden">
                                    <div class="site-input-groups">
                                        <label class="box-input-label"
                                               for="">{{ __('Cancel Expiry') .'(Max 59 Minutes):' }}</label>
                                        <div class="input-group joint-input">
                                            <input type="text" name="expiry_minute"
                                                   onkeypress="return validateNumber(event)"
                                                   class="form-control"/>
                                            <span
                                                    class="input-group-text">{{ __('Minute') }}</span>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Trending:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="schema-trending-yes"
                                                    name="is_trending"
                                                    value="1"
                                            />
                                            <label for="schema-trending-yes">{{ __('Yes') }}</label>
                                            <input
                                                    type="radio"
                                                    id="schema-trending-no"
                                                    name="is_trending"
                                                    checked=""
                                                    value="0"
                                            />
                                            <label for="schema-trending-no">{{ __('No') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Status:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="radio-five"
                                                    name="status"
                                                    checked=""
                                                    value="1"
                                            />
                                            <label for="radio-five">{{ __('Active') }}</label>
                                            <input
                                                    type="radio"
                                                    id="radio-six"
                                                    name="status"
                                                    value="0"
                                            />
                                            <label for="radio-six">{{ __('Deactivate') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <button type="submit" class="site-btn-sm primary-btn w-100">
                                        {{ __('Add New Schema') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('backend/js/choices.min.js') }}"></script>
    <script>

        (function ($) {
            'use strict';

            // Handle Schema Type selection
            $("#fixed-type").on('click', function () {
                $(".schema-min-amount").addClass('hidden');
                $(".schema-max-amount").addClass('hidden');
                $(".schema-fixed-amount").removeClass('hidden');

                $("input[name='schema_min_amount']").removeAttr('required');
                $("input[name='schema_max_amount']").removeAttr('required');
                $("input[name='schema_fixed_amount']").prop('required', true);
            });
            $("#range-type").on('click', function () {
                $(".schema-fixed-amount").addClass('hidden');
                $(".schema-min-amount").removeClass('hidden');
                $(".schema-max-amount").removeClass('hidden');

                $("input[name='schema_fixed_amount']").removeAttr('required');
                $("input[name='schema_min_amount']").prop('required', true);
                $("input[name='schema_max_amount']").prop('required', true);
            });

            $("#featured-no").on('click', function () {
                $("input[name='badge']").removeAttr('required');
                var schemaName = $(".schema-name");
                $(".schema-badge").addClass('hidden');
                schemaName.removeClass('col-xl-6');
                schemaName.addClass('col-xl-12');

            });

            $("#featured-yes").on('click', function () {
                $("input[name='badge']").prop('required', true);
                var schemaName = $(".schema-name");
                $(".schema-badge").removeClass('hidden');
                schemaName.removeClass('col-xl-12');
                schemaName.addClass('col-xl-6');
            });

            $("#schema-cancel-yes").on('click', function () {
                $("input[name='expiry_minute']").prop('required', true);
                var schemaStatus = $(".status");
                $(".cancel-expiry").removeClass('hidden');
            });

            $("#schema-cancel-no").on('click', function () {
                $("input[name='expiry_minute']").removeAttr('required');
                var schemaStatus = $(".status");
                $(".cancel-expiry").addClass('hidden');
            });


            $("#return-type-period").on('click', function () {
                $("input[name='number_of_period']").prop('required', true);
                $(".number-period").removeClass('hidden');
            });

            $("#return-type-lifetime").on('click', function () {
                $("input[name='number_of_period']").removeAttr('required');
                $(".number-period").addClass('hidden');
            });




            // Handle ROI Type selection
            $("#roi-fixed-type").on('click', function () {
                $(".roi-min-amount").addClass('hidden');
                $(".roi-max-amount").addClass('hidden');
                $(".roi-fixed-amount").removeClass('hidden');

                $("input[name='roi_min_amount']").removeAttr('required');
                $("input[name='roi_max_amount']").removeAttr('required');
                $("input[name='roi_fixed_amount']").prop('required', true);
            });

            $("#roi-range-type").on('click', function () {
                $(".roi-fixed-amount").addClass('hidden');
                $(".roi-min-amount").removeClass('hidden');
                $(".roi-max-amount").removeClass('hidden');

                $("input[name='roi_fixed_amount']").removeAttr('required');
                $("input[name='roi_min_amount']").prop('required', true);
                $("input[name='roi_max_amount']").prop('required', true);
            });
            // Trigger the correct state on page load
            $("input[name='schema_type']:checked").trigger('click');
            $("input[name='roi_type']:checked").trigger('click');


            var multipleCancelButton = new Choices('#choices-multiple-remove-button', {
                removeItemButton: true,
                maxItemCount: 7,
                searchResultLimit: 7,
                renderChoiceLimit: 7
            });

        })(jQuery)
    </script>
@endsection

