@if($item->status->value == 'ongoing')
    <div>
        <strong><span id="days{{ $item->id }}"></span>D : <span id="hours{{ $item->id }}"></span>H : <span id="minutes{{ $item->id }}"></span>M : <span id="seconds{{ $item->id }}"></span>S</strong>
        <span class="site-badge primary-bg ms-2" id="percentage{{ $item->id }}"></span>
    </div>
    <div class="progress investment-timeline">
        <div class="progress-bar progress-bar-striped progress-bar-animated" id="time-progress{{ $item->id }}" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
    </div>

    <script>
        (function($) {
            "use strict";
            const second = 1000,
                minute = second * 60,
                hour = minute * 60,
                day = hour * 24;
            let timezone = @json(setting('site_timezone', 'global'));

            let countDown = new Date('{{ $item->next_profit_time}}').getTime()
            var start = new Date('{{ $item->last_profit_time ?? $item->created_at}}').getTime()
            setInterval(function() {

                let utc_datetime_str = new Date().toLocaleString("en-US", {
                    timeZone: timezone
                });
                let now = new Date(utc_datetime_str).getTime();
                let distance = countDown - now;


                var progress = (((now - start) / (countDown - start)) * 100).toFixed(2);


                $("#time-progress{{ $item->id }}").css("width", progress + '%');

                $("#percentage{{ $item->id }}").text(progress >= 100 ? 100 + '%' : progress + '%');

                document.getElementById('days{{ $item->id }}').innerText = Math.floor(distance < 0 ? 0 : distance / (day)),
                    document.getElementById('hours{{ $item->id }}').innerText = Math.floor(distance < 0 ? 0 : (distance % (day)) / (hour)),
                    document.getElementById('minutes{{ $item->id }}').innerText = Math.floor(distance < 0 ? 0 : (distance % (hour)) / (minute)),
                    document.getElementById('seconds{{ $item->id }}').innerText = Math.floor(distance < 0 ? 0 : (distance % (minute)) / second);

            }, second)

        })(jQuery)
    </script>

@elseif($item->status->value == 'completed')
    <div class="site-badge success">{{ __('Completed') }}</div>
    <div class="progress investment-timeline">
        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 100%"></div>
    </div>
@elseif($item->status->value == 'pending')
    <div class="site-badge pending">{{ __('Pending') }}</div>
@elseif($item->status->value == 'canceled')
    <div class="site-badge pending">{{ __('Canceled') }}</div>
@endif